package com.finconsgroup.itserr.marketplace.zenodo.bs.validation;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.CatalogBsClient;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemNotFoundException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemRetrieveException;
import feign.FeignException;
import lombok.RequiredArgsConstructor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

/**
 * Validator component responsible for validating catalog items and ensuring proper authorization.
 */
@Component
@RequiredArgsConstructor
public class CatalogItemValidator {

    /** Client for interacting with the catalog backend service */
    private final CatalogBsClient catalogBsClient;

    /**
     * Validates a catalog item by checking existence and user authorization.
     *
     * @param catalogItemId the unique identifier of the catalog item to validate
     * @return the validated catalog item if all checks pass
     * @throws SourceItemNotFoundException if the catalog item is not found
     * @throws SourceItemRetrieveException if there is an error retrieving the catalog item
     */
    @NonNull
    public OutputCatalogItemDto validate(final String catalogItemId) {

        // Retrieve catalog item
        final OutputCatalogItemDto item;
        try {
            item = catalogBsClient.getItemById(catalogItemId);
        } catch (final FeignException.NotFound e) {
            throw new SourceItemNotFoundException();
        } catch (final Exception e) {
            throw new SourceItemRetrieveException(e);
        }

        // Check user is the creator
        // TODO: check that the catalog item creator id is the same of the authorized user (disabled because of gcat bug), or throw UnallowedSourceItemException

        return item;

    }

}
