package com.finconsgroup.itserr.marketplace.zenodo.bs.service;

import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.OutputZenodoConfigDto;
import org.springframework.lang.NonNull;

/**
 * Service interface for handling Zenodo-related operations.
 *
 * <p>This interface defines the contract for services that interact with Zenodo,
 * providing functionality for retrieving configuration and managing Zenodo-related operations.</p>
 */
public interface ZenodoService {

    /**
     * <p>Retrieves the Zenodo configuration settings.</p>
     *
     * <p>This method provides the configuration details required for interacting with the Zenodo API,
     * such as the host, client identifier, and OAuth scopes.</p>
     *
     * @return an {@code OutputZenodoConfigDto} instance containing Zenodo configuration details.
     */
    OutputZenodoConfigDto getConfig();

    /**
     * Creates a new export request to Zenodo using the provided data.
     *
     * @param request the input data transfer object containing the information required for the Zenodo export. This includes source information (type
     *         and ID) and Zenodo authentication details, such as the authorization code.
     */
    void createExport(@NonNull final InputCreateZenodoExportDto request);

}
