package com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.dto;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * DTO class for representing export request creation event messages. Extends MessagingEventDto to provide event messaging functionality.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@ToString(callSuper = true)
public class ExportRequestCreatedMessageBodyDto
        extends MessagingEventDto<ExportRequestCreatedMessageBodyDto.AdditionalData> {

    /**
     * Additional data for the event.
     */
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AdditionalData {

        /** Type of the source system */
        private String sourceType;

        /** JWT token for D4Science authorization */
        private String d4sJwtToken;

        /** JWT token for Zenodo authorization */
        private String zenodoJwtToken;

        /** Refresh token for Zenodo JWT authorization */
        private String zenodoJwtRefreshToken;

    }

}
