package com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.configuration.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for the messaging.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "zenodo.bs.messaging")
public class MessagingConfigurationProperties {

    /**
     * Name of the configured event producer
     */
    @NotBlank
    private String eventProducerName;

    /**
     * Source identifier for events, used to indicate the origin of a message.
     */
    @NotBlank
    private String source;

    /**
     * Event type string used for export request created events.
     */
    @NotBlank
    private String exportRequestCreatedEventType;

}
