package com.finconsgroup.itserr.marketplace.zenodo.bs.messaging;

import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.dto.ExportRequestCreatedMessageBodyDto;
import org.springframework.lang.NonNull;

/**
 * Interface for publishing events related to Zenodo system.
 */
public interface EventProducer {

    /**
     * Publishes an event indicating that a new export request has been created.
     *
     * @param resource The DTO containing the export request details that was created
     */
    void publishExportRequestCreatedEvent(@NonNull ExportRequestCreatedMessageBodyDto resource);

}
