package com.finconsgroup.itserr.marketplace.zenodo.bs.mapper;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.OutputOauthTokenDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.dto.ExportRequestCreatedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CreateExportRequestValidator;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-04T22:24:08+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ExportRequestMapperImpl implements ExportRequestMapper {

    @Override
    public ExportRequestCreatedMessageBodyDto toMessageDto(CreateExportRequestValidator.ValidatedRequest src) {
        if ( src == null ) {
            return null;
        }

        ExportRequestCreatedMessageBodyDto.ExportRequestCreatedMessageBodyDtoBuilder<?, ?> exportRequestCreatedMessageBodyDto = ExportRequestCreatedMessageBodyDto.builder();

        exportRequestCreatedMessageBodyDto.id( srcRequestSourceId( src ) );
        exportRequestCreatedMessageBodyDto.title( srcCatalogItemTitle( src ) );

        exportRequestCreatedMessageBodyDto.user( this.getMessageUserFromSecurity() );
        exportRequestCreatedMessageBodyDto.timestamp( java.time.Instant.now() );
        exportRequestCreatedMessageBodyDto.additionalData( this.toExportRequestCreateAdditionalDataDto(src) );

        return exportRequestCreatedMessageBodyDto.build();
    }

    @Override
    public ExportRequestCreatedMessageBodyDto.AdditionalData toExportRequestCreateAdditionalDataDto(CreateExportRequestValidator.ValidatedRequest src) {
        if ( src == null ) {
            return null;
        }

        ExportRequestCreatedMessageBodyDto.AdditionalData.AdditionalDataBuilder additionalData = ExportRequestCreatedMessageBodyDto.AdditionalData.builder();

        InputCreateZenodoExportDto.SourceType type = srcRequestSourceType( src );
        if ( type != null ) {
            additionalData.sourceType( type.name() );
        }
        additionalData.zenodoJwtToken( srcZenodoTokenAccessToken( src ) );
        additionalData.zenodoJwtRefreshToken( srcZenodoTokenRefreshToken( src ) );

        additionalData.d4sJwtToken( com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder.getToken() );

        return additionalData.build();
    }

    private String srcRequestSourceId(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        InputCreateZenodoExportDto request = validatedRequest.request();
        if ( request == null ) {
            return null;
        }
        InputCreateZenodoExportDto.SourceDto source = request.getSource();
        if ( source == null ) {
            return null;
        }
        return source.getId();
    }

    private String srcCatalogItemTitle(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputCatalogItemDto catalogItem = validatedRequest.catalogItem();
        if ( catalogItem == null ) {
            return null;
        }
        return catalogItem.getTitle();
    }

    private InputCreateZenodoExportDto.SourceType srcRequestSourceType(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        InputCreateZenodoExportDto request = validatedRequest.request();
        if ( request == null ) {
            return null;
        }
        InputCreateZenodoExportDto.SourceDto source = request.getSource();
        if ( source == null ) {
            return null;
        }
        return source.getType();
    }

    private String srcZenodoTokenAccessToken(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputOauthTokenDto zenodoToken = validatedRequest.zenodoToken();
        if ( zenodoToken == null ) {
            return null;
        }
        return zenodoToken.getAccessToken();
    }

    private String srcZenodoTokenRefreshToken(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputOauthTokenDto zenodoToken = validatedRequest.zenodoToken();
        if ( zenodoToken == null ) {
            return null;
        }
        return zenodoToken.getRefreshToken();
    }
}
