package com.finconsgroup.itserr.marketplace.zenodo.bs;

import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoConfigurationProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.configuration.properties.MessagingConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * Main Spring Boot application class for the Zenodo microservice.
 */
@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "Zenodo Bs API",
        description = "API definition of the Zenodo Microservice",
        version = "1.0.0"
))
@EnableConfigurationProperties({
        ZenodoConfigurationProperties.class,
        MessagingConfigurationProperties.class,
})
public class ZenodoBsApplication {

    /**
     * Main method that starts the Spring Boot application.
     *
     * @param args command line arguments passed to the application
     */
    public static void main(String[] args) {
        SpringApplication.run(ZenodoBsApplication.class, args);
    }

}
