package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ManualReferenceEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-06T19:15:58+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ManualReferenceMapperImpl implements ManualReferenceMapper {

    @Autowired
    private AuthorMapper authorMapper;
    @Autowired
    private PublicationMapper publicationMapper;

    @Override
    public ManualReferenceEntity toEntity(InputManualReferenceDto model) {
        if ( model == null ) {
            return null;
        }

        ManualReferenceEntity.ManualReferenceEntityBuilder<?, ?> manualReferenceEntity = ManualReferenceEntity.builder();

        manualReferenceEntity.title( model.getTitle() );
        manualReferenceEntity.journalOrConference( model.getJournalOrConference() );
        manualReferenceEntity.url( model.getUrl() );
        manualReferenceEntity.volume( model.getVolume() );
        manualReferenceEntity.pages( model.getPages() );
        manualReferenceEntity.paragraph( model.getParagraph() );
        manualReferenceEntity.authors( inputAuthorDtoListToAuthorEntityList( model.getAuthors() ) );
        manualReferenceEntity.publication( publicationMapper.toEntity( model.getPublication() ) );

        ManualReferenceEntity manualReferenceEntityResult = manualReferenceEntity.build();

        setAuthors( manualReferenceEntityResult );
        setPublication( manualReferenceEntityResult );

        return manualReferenceEntityResult;
    }

    @Override
    public OutputManualReferenceDto toDto(ManualReferenceEntity entity) {
        if ( entity == null ) {
            return null;
        }

        OutputManualReferenceDto.OutputManualReferenceDtoBuilder outputManualReferenceDto = OutputManualReferenceDto.builder();

        outputManualReferenceDto.title( entity.getTitle() );
        outputManualReferenceDto.journalOrConference( entity.getJournalOrConference() );
        outputManualReferenceDto.url( entity.getUrl() );
        outputManualReferenceDto.volume( entity.getVolume() );
        outputManualReferenceDto.pages( entity.getPages() );
        outputManualReferenceDto.paragraph( entity.getParagraph() );
        outputManualReferenceDto.publication( publicationMapper.toDto( entity.getPublication() ) );
        outputManualReferenceDto.authors( authorEntityListToOutputAuthorDtoList( entity.getAuthors() ) );

        return outputManualReferenceDto.build();
    }

    protected List<AuthorEntity> inputAuthorDtoListToAuthorEntityList(List<InputAuthorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<AuthorEntity> list1 = new ArrayList<AuthorEntity>( list.size() );
        for ( InputAuthorDto inputAuthorDto : list ) {
            list1.add( authorMapper.toEntity( inputAuthorDto ) );
        }

        return list1;
    }

    protected OutputAuthorDto authorEntityToOutputAuthorDto(AuthorEntity authorEntity) {
        if ( authorEntity == null ) {
            return null;
        }

        OutputAuthorDto.OutputAuthorDtoBuilder outputAuthorDto = OutputAuthorDto.builder();

        outputAuthorDto.firstName( authorEntity.getFirstName() );
        outputAuthorDto.lastName( authorEntity.getLastName() );
        outputAuthorDto.email( authorEntity.getEmail() );
        outputAuthorDto.orcid( authorEntity.getOrcid() );

        return outputAuthorDto.build();
    }

    protected List<OutputAuthorDto> authorEntityListToOutputAuthorDtoList(List<AuthorEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputAuthorDto> list1 = new ArrayList<OutputAuthorDto>( list.size() );
        for ( AuthorEntity authorEntity : list ) {
            list1.add( authorEntityToOutputAuthorDto( authorEntity ) );
        }

        return list1;
    }
}
