package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.userprofile.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * Input DTO for creating a work location.
 */
@Schema(name = "InputWorkingLocationDTO", description = "DTO for creating a working location")
@Data
@Builder
@AllArgsConstructor
public class InputWorkingLocationDto {

    @Schema(description = "City", example = "Palo Alto")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String city;

    @Schema(description = "Region or State", example = "CA")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String region;

    @Schema(description = "Country", example = "USA")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String country;

    @Schema(description = "ZipCode", example = "90100")
    @Size(max = 100, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String zipCode;
}

