package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPublicationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.PublicationEntity;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-06T12:22:00+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class PublicationMapperImpl implements PublicationMapper {

    @Override
    public PublicationEntity toEntity(InputPublicationDto dto) {
        if ( dto == null ) {
            return null;
        }

        PublicationEntity.PublicationEntityBuilder<?, ?> publicationEntity = PublicationEntity.builder();

        publicationEntity.city( dtoLocationCity( dto ) );
        publicationEntity.region( dtoLocationRegion( dto ) );
        publicationEntity.country( dtoLocationCountry( dto ) );
        publicationEntity.zipCode( dtoLocationZipCode( dto ) );
        publicationEntity.date( dto.getDate() );

        return publicationEntity.build();
    }

    @Override
    public OutputPublicationDto toDto(PublicationEntity entity) {
        if ( entity == null ) {
            return null;
        }

        OutputPublicationDto.OutputPublicationDtoBuilder outputPublicationDto = OutputPublicationDto.builder();

        outputPublicationDto.location( publicationEntityToOutputWorkingLocationDto( entity ) );
        outputPublicationDto.date( entity.getDate() );

        return outputPublicationDto.build();
    }

    private String dtoLocationCity(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getCity();
    }

    private String dtoLocationRegion(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getRegion();
    }

    private String dtoLocationCountry(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getCountry();
    }

    private String dtoLocationZipCode(InputPublicationDto inputPublicationDto) {
        InputWorkingLocationDto location = inputPublicationDto.getLocation();
        if ( location == null ) {
            return null;
        }
        return location.getZipCode();
    }

    protected OutputWorkingLocationDto publicationEntityToOutputWorkingLocationDto(PublicationEntity publicationEntity) {
        if ( publicationEntity == null ) {
            return null;
        }

        OutputWorkingLocationDto.OutputWorkingLocationDtoBuilder outputWorkingLocationDto = OutputWorkingLocationDto.builder();

        outputWorkingLocationDto.city( publicationEntity.getCity() );
        outputWorkingLocationDto.region( publicationEntity.getRegion() );
        outputWorkingLocationDto.country( publicationEntity.getCountry() );
        outputWorkingLocationDto.zipCode( publicationEntity.getZipCode() );

        return outputWorkingLocationDto.build();
    }
}
