package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * DTO for removing project from user profile info for provided ids.
 */
@Schema(name = "RemoveProjectFromUserProfilesDto", description = "DTO for removing project from user profile for provided ids")
@Data
@Builder
@AllArgsConstructor
public class InputRemoveProjectFromUserProfilesDto {

    @NotEmpty
    @Schema(
            description = "Ids of the user profiles to update",
            example = "[\"550e8400-e29b-41d4-a716-446655440000\", \"550e8400-e29b-41d4-a716-446655449999\"]")
    List<UUID> userIds;

    @NotNull
    @Schema(
            description = "Id of the project to be removed from user profiles",
            example = "550e8400-e29b-41d4-a716-446655440000")
    UUID projectId;
}
