/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileStatusChangeDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputCVDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.CVEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ProjectEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.WorkingLocationEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.CVMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.EndorsementMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ExpertiseMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ReferenceMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.UserPreferenceMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.WorkingLocationMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProfileMapperImpl
implements UserProfileMapper {
    @Autowired
    private EndorsementMapper endorsementMapper;
    @Autowired
    private ExpertiseMapper expertiseMapper;
    @Autowired
    private UserPreferenceMapper userPreferenceMapper;
    @Autowired
    private ReferenceMapper referenceMapper;
    @Autowired
    private CVMapper cVMapper;
    @Autowired
    private WorkingLocationMapper workingLocationMapper;

    public UserProfileEntity toEntity(InputUserProfileDto model, UUID userId) {
        if (model == null && userId == null) {
            return null;
        }
        UserProfileEntity.UserProfileEntityBuilder userProfileEntity = UserProfileEntity.builder();
        if (model != null) {
            userProfileEntity.userProfileFolderId(model.getUserProfileFolderId());
            userProfileEntity.imageUrl(model.getImageUrl());
            userProfileEntity.orcid(model.getOrcid());
            userProfileEntity.openToCollaboration(model.isOpenToCollaboration());
            userProfileEntity.showPublicEmail(model.isShowPublicEmail());
            userProfileEntity.personalWebsite(model.getPersonalWebsite());
            userProfileEntity.linkedinProfile(model.getLinkedinProfile());
            userProfileEntity.socialProfile(model.getSocialProfile());
            userProfileEntity.shortBio(model.getShortBio());
            userProfileEntity.organizationAffiliation(model.getOrganizationAffiliation());
            List list = model.getSsd();
            if (list != null) {
                userProfileEntity.ssd(new ArrayList(list));
            }
            userProfileEntity.expertises(this.inputExpertiseDtoListToExpertiseEntityList(model.getExpertises()));
            userProfileEntity.cv(this.cVMapper.toEntity(model.getCv()));
            userProfileEntity.workingLocation(this.workingLocationMapper.toEntity(model.getWorkingLocation()));
            userProfileEntity.references(this.referenceMapper.toEntity(model.getReferences()));
            userProfileEntity.publicProfile(model.isPublicProfile());
            List list2 = model.getInterests();
            if (list2 != null) {
                userProfileEntity.interests(new ArrayList(list2));
            }
            userProfileEntity.preferences(this.userPreferenceMapper.toEntity(model.getPreferences()));
            userProfileEntity.language(model.getLanguage());
            userProfileEntity.emailConsent(model.isEmailConsent());
        }
        UserProfileEntity userProfileEntityResult = userProfileEntity.build();
        this.setCV(userProfileEntityResult);
        this.setWorkingLocation(userProfileEntityResult);
        this.setReference(userProfileEntityResult);
        this.setProjects(userProfileEntityResult);
        this.setPreference(userProfileEntityResult);
        this.setExpertise(userProfileEntityResult);
        return userProfileEntityResult;
    }

    public OutputUserProfileDto toDto(UserProfileEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputUserProfileDto.OutputUserProfileDtoBuilder outputUserProfileDto = OutputUserProfileDto.builder();
        outputUserProfileDto.id(entity.getId());
        outputUserProfileDto.firstName(entity.getFirstName());
        outputUserProfileDto.lastName(entity.getLastName());
        outputUserProfileDto.email(entity.getEmail());
        outputUserProfileDto.preferredUsername(entity.getPreferredUsername());
        outputUserProfileDto.userProfileFolderId(entity.getUserProfileFolderId());
        outputUserProfileDto.imageUrl(entity.getImageUrl());
        outputUserProfileDto.projects(this.projectEntityListToOutputProjectDtoList(entity.getProjects()));
        outputUserProfileDto.cv(this.cVEntityToOutputCVDto(entity.getCv()));
        outputUserProfileDto.orcid(entity.getOrcid());
        outputUserProfileDto.openToCollaboration(entity.isOpenToCollaboration());
        outputUserProfileDto.showPublicEmail(entity.isShowPublicEmail());
        outputUserProfileDto.personalWebsite(entity.getPersonalWebsite());
        outputUserProfileDto.linkedinProfile(entity.getLinkedinProfile());
        outputUserProfileDto.socialProfile(entity.getSocialProfile());
        outputUserProfileDto.shortBio(entity.getShortBio());
        outputUserProfileDto.workingLocation(this.workingLocationEntityToOutputWorkingLocationDto(entity.getWorkingLocation()));
        outputUserProfileDto.organizationAffiliation(entity.getOrganizationAffiliation());
        List list1 = entity.getSsd();
        if (list1 != null) {
            outputUserProfileDto.ssd(new ArrayList(list1));
        }
        outputUserProfileDto.expertises(this.expertiseEntityListToOutputExpertiseDtoList(entity.getExpertises()));
        outputUserProfileDto.references(this.referenceMapper.toDto(entity.getReferences()));
        outputUserProfileDto.creationTime(entity.getCreationTime());
        outputUserProfileDto.updateTime(entity.getUpdateTime());
        outputUserProfileDto.language(entity.getLanguage());
        outputUserProfileDto.publicProfile(entity.isPublicProfile());
        List list3 = entity.getInterests();
        if (list3 != null) {
            outputUserProfileDto.interests(new ArrayList(list3));
        }
        outputUserProfileDto.emailConsent(entity.isEmailConsent());
        outputUserProfileDto.preferences(this.userPreferenceMapper.toDto(entity.getPreferences()));
        outputUserProfileDto.hidePanel(Boolean.valueOf(entity.isHidePanel()));
        return outputUserProfileDto.build();
    }

    public void updateEntity(InputUpdateUserProfileDto dto, UserProfileEntity entity) {
        if (dto == null) {
            return;
        }
        entity.setImageUrl(dto.getImageUrl());
        entity.setOrcid(dto.getOrcid());
        entity.setOpenToCollaboration(dto.isOpenToCollaboration());
        entity.setShowPublicEmail(dto.isShowPublicEmail());
        entity.setPersonalWebsite(dto.getPersonalWebsite());
        entity.setLinkedinProfile(dto.getLinkedinProfile());
        entity.setSocialProfile(dto.getSocialProfile());
        entity.setShortBio(dto.getShortBio());
        entity.setOrganizationAffiliation(dto.getOrganizationAffiliation());
        if (entity.getSsd() != null) {
            list = dto.getSsd();
            if (list != null) {
                entity.getSsd().clear();
                entity.getSsd().addAll(list);
            } else {
                entity.setSsd(null);
            }
        } else {
            list = dto.getSsd();
            if (list != null) {
                entity.setSsd(new ArrayList(list));
            }
        }
        entity.setCv(this.cVMapper.toEntity(dto.getCv()));
        entity.setWorkingLocation(this.workingLocationMapper.toEntity(dto.getWorkingLocation()));
        entity.setReferences(this.referenceMapper.toEntity(dto.getReferences()));
        entity.setPublicProfile(dto.isPublicProfile());
        if (entity.getInterests() != null) {
            list1 = dto.getInterests();
            if (list1 != null) {
                entity.getInterests().clear();
                entity.getInterests().addAll(list1);
            } else {
                entity.setInterests(null);
            }
        } else {
            list1 = dto.getInterests();
            if (list1 != null) {
                entity.setInterests(new ArrayList(list1));
            }
        }
        entity.setPreferences(this.userPreferenceMapper.toEntity(dto.getPreferences()));
        entity.setLanguage(dto.getLanguage());
        this.setCV(entity);
        this.setWorkingLocation(entity);
        this.setReference(entity);
        this.setProjects(entity);
        this.setPreference(entity);
        this.setExpertise(entity);
    }

    public void patchEntity(InputPatchUserProfileDto dto, UserProfileEntity entity) {
        if (dto == null) {
            return;
        }
        if (dto.getImageUri() != null) {
            entity.setImageUrl(this.map(dto.getImageUri()));
        }
        if (dto.getInputCVDto() != null) {
            entity.setCv(this.cVMapper.toEntity(dto.getInputCVDto()));
        }
        if (dto.getLanguage() != null) {
            entity.setLanguage(dto.getLanguage());
        }
        if (dto.getEmailConsent() != null) {
            entity.setEmailConsent(dto.getEmailConsent().booleanValue());
        }
        if (dto.getHidePanel() != null) {
            entity.setHidePanel(dto.getHidePanel().booleanValue());
        }
        this.setCV(entity);
        this.setWorkingLocation(entity);
        this.setReference(entity);
        this.setProjects(entity);
        this.setPreference(entity);
        this.setExpertise(entity);
    }

    public OutputPatchUserProfileDto toPatchUserDto(UserProfileEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputPatchUserProfileDto.OutputPatchUserProfileDtoBuilder outputPatchUserProfileDto = OutputPatchUserProfileDto.builder();
        outputPatchUserProfileDto.outputCVDto(this.cVEntityToOutputCVDto1(entity.getCv()));
        outputPatchUserProfileDto.imageUri(this.map(entity.getImageUrl()));
        outputPatchUserProfileDto.language(entity.getLanguage());
        outputPatchUserProfileDto.emailConsent(Boolean.valueOf(entity.isEmailConsent()));
        outputPatchUserProfileDto.hidePanel(Boolean.valueOf(entity.isHidePanel()));
        return outputPatchUserProfileDto.build();
    }

    public void patchEntity(InputUserProfileStatusChangeDto dto, UserProfileEntity entity) {
        if (dto == null) {
            return;
        }
        if (dto.getPublicProfile() != null) {
            entity.setPublicProfile(dto.getPublicProfile().booleanValue());
        }
        this.setCV(entity);
        this.setWorkingLocation(entity);
        this.setReference(entity);
        this.setProjects(entity);
        this.setPreference(entity);
        this.setExpertise(entity);
    }

    public void patchEntity(InputAdminPatchUserProfileDto dto, UserProfileEntity entity) {
        if (dto == null) {
            return;
        }
        if (dto.getPublicProfile() != null) {
            entity.setPublicProfile(dto.getPublicProfile().booleanValue());
        }
        this.setCV(entity);
        this.setWorkingLocation(entity);
        this.setReference(entity);
        this.setProjects(entity);
        this.setPreference(entity);
        this.setExpertise(entity);
    }

    public OutputAdminPatchUserProfileDto toAdminPatchUserProfileDto(UserProfileEntity entity) {
        if (entity == null) {
            return null;
        }
        OutputAdminPatchUserProfileDto.OutputAdminPatchUserProfileDtoBuilder outputAdminPatchUserProfileDto = OutputAdminPatchUserProfileDto.builder();
        outputAdminPatchUserProfileDto.publicProfile(Boolean.valueOf(entity.isPublicProfile()));
        return outputAdminPatchUserProfileDto.build();
    }

    protected List<ExpertiseEntity> inputExpertiseDtoListToExpertiseEntityList(List<InputExpertiseDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExpertiseEntity> list1 = new ArrayList<ExpertiseEntity>(list.size());
        for (InputExpertiseDto inputExpertiseDto : list) {
            list1.add(this.expertiseMapper.toEntity(inputExpertiseDto));
        }
        return list1;
    }

    protected OutputProjectDto projectEntityToOutputProjectDto(ProjectEntity projectEntity) {
        if (projectEntity == null) {
            return null;
        }
        OutputProjectDto.OutputProjectDtoBuilder outputProjectDto = OutputProjectDto.builder();
        outputProjectDto.projectId(projectEntity.getProjectId());
        outputProjectDto.displayName(projectEntity.getDisplayName());
        outputProjectDto.wp(projectEntity.getWp());
        outputProjectDto.rootProjectId(projectEntity.getRootProjectId());
        outputProjectDto.rootProjectDisplayName(projectEntity.getRootProjectDisplayName());
        outputProjectDto.wpLead(projectEntity.getWpLead());
        return outputProjectDto.build();
    }

    protected List<OutputProjectDto> projectEntityListToOutputProjectDtoList(List<ProjectEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputProjectDto> list1 = new ArrayList<OutputProjectDto>(list.size());
        for (ProjectEntity projectEntity : list) {
            list1.add(this.projectEntityToOutputProjectDto(projectEntity));
        }
        return list1;
    }

    protected OutputCVDto cVEntityToOutputCVDto(CVEntity cVEntity) {
        if (cVEntity == null) {
            return null;
        }
        OutputCVDto.OutputCVDtoBuilder outputCVDto = OutputCVDto.builder();
        outputCVDto.fileUrl(cVEntity.getFileUrl());
        outputCVDto.filename(cVEntity.getFilename());
        outputCVDto.size(cVEntity.getSize());
        return outputCVDto.build();
    }

    protected OutputWorkingLocationDto workingLocationEntityToOutputWorkingLocationDto(WorkingLocationEntity workingLocationEntity) {
        if (workingLocationEntity == null) {
            return null;
        }
        OutputWorkingLocationDto.OutputWorkingLocationDtoBuilder outputWorkingLocationDto = OutputWorkingLocationDto.builder();
        outputWorkingLocationDto.city(workingLocationEntity.getCity());
        outputWorkingLocationDto.region(workingLocationEntity.getRegion());
        outputWorkingLocationDto.country(workingLocationEntity.getCountry());
        outputWorkingLocationDto.zipCode(workingLocationEntity.getZipCode());
        return outputWorkingLocationDto.build();
    }

    protected List<OutputEndorsementDto> endorsementEntityListToOutputEndorsementDtoList(List<EndorsementEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputEndorsementDto> list1 = new ArrayList<OutputEndorsementDto>(list.size());
        for (EndorsementEntity endorsementEntity : list) {
            list1.add(this.endorsementMapper.toDto(endorsementEntity));
        }
        return list1;
    }

    protected OutputExpertiseDto expertiseEntityToOutputExpertiseDto(ExpertiseEntity expertiseEntity) {
        if (expertiseEntity == null) {
            return null;
        }
        OutputExpertiseDto.OutputExpertiseDtoBuilder outputExpertiseDto = OutputExpertiseDto.builder();
        outputExpertiseDto.id(expertiseEntity.getId());
        outputExpertiseDto.labelId(expertiseEntity.getLabelId());
        outputExpertiseDto.displayName(expertiseEntity.getDisplayName());
        outputExpertiseDto.endorsementCount(expertiseEntity.getEndorsementCount());
        outputExpertiseDto.endorsements(this.endorsementEntityListToOutputEndorsementDtoList(expertiseEntity.getEndorsements()));
        return outputExpertiseDto.build();
    }

    protected List<OutputExpertiseDto> expertiseEntityListToOutputExpertiseDtoList(List<ExpertiseEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<OutputExpertiseDto> list1 = new ArrayList<OutputExpertiseDto>(list.size());
        for (ExpertiseEntity expertiseEntity : list) {
            list1.add(this.expertiseEntityToOutputExpertiseDto(expertiseEntity));
        }
        return list1;
    }

    protected OutputCVDto cVEntityToOutputCVDto1(CVEntity cVEntity) {
        if (cVEntity == null) {
            return null;
        }
        OutputCVDto.OutputCVDtoBuilder outputCVDto = OutputCVDto.builder();
        outputCVDto.fileUrl(cVEntity.getFileUrl());
        outputCVDto.filename(cVEntity.getFilename());
        outputCVDto.size(cVEntity.getSize());
        return outputCVDto.build();
    }
}

