package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Output DTO representing a reference.
 */
@Schema(name = "OutputReferenceDto", description = "DTO representing a reference in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputReferenceDto {

    @Schema(description = "DOI", example = "[\"10.1000/xyz123\", \"10.1000/xyz124\"]")
    private List<String> dois;

    @Schema(description = "manual references")
    private List<OutputManualReferenceDto> manualReferences;
}
