create schema if not exists "wp2_user_profile";

set schema 'wp2_user_profile';

-- liquibase formatted sql

-- user_profile table
CREATE TABLE IF NOT EXISTS "user_profile" (
    "id" UUID NOT NULL,
    "first_name" VARCHAR(100) NOT NULL,
    "last_name" VARCHAR(100) NOT NULL,
    "email" VARCHAR(255) NOT NULL,
    "profile_folder_id" UUID,
    "image_url" VARCHAR(255),
    "orcid" VARCHAR(255),
    "open_to_collaboration" BOOLEAN,
    "show_public_email" BOOLEAN,
    "personal_website" VARCHAR(255),
    "linkedin_profile" VARCHAR(255),
    "social_profile" VARCHAR(255),
    "short_bio" VARCHAR(1000),
    "organization_affiliation" VARCHAR(255),
    "ssd" TEXT,
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    "language" VARCHAR(10) DEFAULT 'EN' NOT NULL,
    "preferred_username" VARCHAR(100),
    "public_profile" BOOLEAN,
    "interests" TEXT,
    "email_consent" BOOLEAN DEFAULT FALSE,
    "hide_panel" BOOLEAN DEFAULT FALSE,
    CONSTRAINT "user_profile_pkey" PRIMARY KEY ("id")
);

-- cv table
CREATE TABLE IF NOT EXISTS "cv" (
    "id" UUID NOT NULL,
    "user_profile_id" UUID,
    "file_url" VARCHAR(255),
    "filename" VARCHAR(255),
    "size" BIGINT NOT NULL,
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "cv_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "cv_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"("id") ON DELETE CASCADE
);

-- working_location table
CREATE TABLE IF NOT EXISTS "working_location" (
    "id" UUID NOT NULL,
    "user_profile_id" UUID NOT NULL,
    "city" VARCHAR(100),
    "region" VARCHAR(100),
    "country" VARCHAR(100),
    "zip_code" VARCHAR(100),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "working_location_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "working_location_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"("id") ON DELETE CASCADE
);

-- reference table
CREATE TABLE IF NOT EXISTS "reference" (
    "id" UUID NOT NULL,
    "user_profile_id" UUID NOT NULL,
    "dois" TEXT,
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "reference_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "reference_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"("id") ON DELETE CASCADE
);

-- manual_reference table
CREATE TABLE IF NOT EXISTS "manual_reference" (
    "id" UUID NOT NULL,
    "reference_id" UUID NOT NULL,
    "title" VARCHAR(255),
    "journal_or_conference" VARCHAR(255),
    "url" VARCHAR(255),
    "volume" VARCHAR(100),
    "pages" VARCHAR(100),
    "paragraph" VARCHAR(100),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "manual_reference_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "manual_reference_reference_id_fkey" FOREIGN KEY ("reference_id") REFERENCES "reference"("id") ON DELETE CASCADE
);

-- publication table
CREATE TABLE IF NOT EXISTS "publication" (
    "id" UUID NOT NULL,
    "manual_reference_id" UUID NOT NULL,
    "date" date,
    "city" VARCHAR(100),
    "region" VARCHAR(100),
    "country" VARCHAR(100),
    "zip_code" VARCHAR(100),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "publication_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "publication_manual_reference_id_fkey" FOREIGN KEY ("manual_reference_id") REFERENCES "manual_reference"("id") ON DELETE CASCADE
);

-- author table
CREATE TABLE IF NOT EXISTS "author" (
    "id" UUID NOT NULL,
    "manual_reference_id" UUID NOT NULL,
    "first_name" VARCHAR(100),
    "last_name" VARCHAR(100),
    "email" VARCHAR(255),
    "orcid" VARCHAR(255),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "author_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "author_manual_reference_id_fkey" FOREIGN KEY ("manual_reference_id") REFERENCES "manual_reference"("id") ON DELETE CASCADE
);

-- project table
CREATE TABLE IF NOT EXISTS "project" (
    "id" UUID NOT NULL,
    "user_profile_id" UUID NOT NULL,
    "project_id" UUID,
    "display_name" VARCHAR(255),
    "wp" VARCHAR(100),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    "root_project_id" UUID,
    "root_project_display_name" VARCHAR(255),
    "wp_lead" BOOLEAN,
    CONSTRAINT "project_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "project_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"("id") ON DELETE CASCADE
);

-- user_preference table
CREATE TABLE IF NOT EXISTS "user_preference" (
    "id" UUID NOT NULL,
    "user_profile_id" UUID NOT NULL,
    "theme" VARCHAR(100),
    "creation_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "update_time" TIMESTAMP WITH TIME ZONE NOT NULL,
    "version" BIGINT DEFAULT 0 NOT NULL,
    CONSTRAINT "user_preference_pkey" PRIMARY KEY ("id"),
    CONSTRAINT "user_preference_user_profile_id_fkey" FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"("id") ON DELETE CASCADE
);

-- expertise table
CREATE TABLE IF NOT EXISTS "expertise" (
    "id" uuid PRIMARY KEY,
    "user_profile_id" UUID NOT NULL,
    "label_id" UUID NOT NULL,
    "display_name" varchar(100),
    "endorsement_count" integer,
    "creation_time" timestamptz(6) NOT NULL,
    "update_time" timestamptz(6) NOT NULL,
    "version" bigint NOT NULL default 0,
    "expertise_order" bigint NOT NULL default 0,
    CONSTRAINT fk_expertise_user_id FOREIGN KEY ("user_profile_id") REFERENCES "user_profile"(id) ON DELETE CASCADE
);

-- endorsement table
CREATE TABLE IF NOT EXISTS "endorsement" (
    "id" uuid PRIMARY KEY,
    "expertise_id" UUID NOT NULL,
    "endorser_id" UUID NOT NULL,
    "creation_time" timestamptz(6) NOT NULL,
    "update_time" timestamptz(6) NOT NULL,
    "version" bigint NOT NULL default 0,
    "endorsement_order" bigint NOT NULL default 0,
    CONSTRAINT fk_endorsement_expertise_id FOREIGN KEY ("expertise_id") REFERENCES "expertise"(id) ON DELETE CASCADE
);

-- archived_expertise table
CREATE TABLE IF NOT EXISTS "archived_expertise" (
    "id" uuid PRIMARY KEY,
    "user_profile_id" UUID NOT NULL,
    "label_id" UUID NOT NULL,
    "display_name" varchar(100),
    "endorsement_count" integer,
    "creation_time" timestamptz(6) NOT NULL,
    "update_time" timestamptz(6) NOT NULL,
    "archive_time" timestamptz(6) NOT NULL,
    "version" bigint NOT NULL default 0,
    "expertise_order" bigint NOT NULL default 0
);

-- archived_endorsement table
CREATE TABLE IF NOT EXISTS "archived_endorsement" (
    "id" uuid PRIMARY KEY,
    "expertise_id" UUID NOT NULL,
    "endorser_id" UUID NOT NULL,
    "creation_time" timestamptz(6) NOT NULL,
    "update_time" timestamptz(6) NOT NULL,
    "archive_time" timestamptz(6) NOT NULL,
    "version" bigint NOT NULL default 0,
    "endorsement_order" bigint NOT NULL default 0
);

-- retain all ALTER TABLE DROP COLUMN statements as-is
ALTER TABLE "user_profile" DROP COLUMN IF EXISTS "expertises";
