package com.finconsgroup.itserr.marketplace.userprofile.dm.service.impl;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.exception.UserProfileNotFoundException;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.repository.UserProfileRepository;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.AdminService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.UUID;

/**
 * Default implementation of {@link AdminService}
 * to perform operations related to userprofile resources
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultAdminService implements AdminService {

    private final UserProfileRepository userProfileRepository;
    private final UserProfileMapper userProfileMapper;

    @NonNull
    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public OutputAdminPatchUserProfileDto patchUserProfile(@NonNull UUID profileId, @NonNull InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto) {
        UserProfileEntity userProfileEntity = userProfileRepository.findById(profileId)
                .orElseThrow(() -> new UserProfileNotFoundException(profileId));
        userProfileMapper.patchEntity(inputAdminPatchUserProfileDto, userProfileEntity);
        UserProfileEntity savedUserProfileEntity = userProfileRepository.save(userProfileEntity);
        return userProfileMapper.toAdminPatchUserProfileDto(savedUserProfileEntity);
    }
}