package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileStatusChangeDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeanMapping;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

import java.net.URI;
import java.util.UUID;

@Mapper(config = MapperConfiguration.class, uses = {EndorsementMapper.class, ExpertiseMapper.class, UserPreferenceMapper.class, ReferenceMapper.class, CVMapper.class, WorkingLocationMapper.class, ProjectMapper.class})
public interface UserProfileMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "firstName", ignore = true)
    @Mapping(target = "lastName", ignore = true)
    @Mapping(target = "email", ignore = true)
    @Mapping(target = "preferredUsername", ignore = true)
    @Mapping(target = "projects", ignore = true)
    @Mapping(target = "hidePanel", ignore = true)
    UserProfileEntity toEntity(InputUserProfileDto model, UUID userId);

    @Mapping(target = "userExists", ignore = true)
    OutputUserProfileDto toDto(UserProfileEntity entity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "firstName", ignore = true)
    @Mapping(target = "lastName", ignore = true)
    @Mapping(target = "email", ignore = true)
    @Mapping(target = "userProfileFolderId", ignore = true)
    @Mapping(target = "preferredUsername", ignore = true)
    @Mapping(target = "projects", ignore = true)
    @Mapping(target = "expertises", ignore = true)
    @Mapping(target = "hidePanel", ignore = true)
    @Mapping(target = "emailConsent", ignore = true)
    // Avoid setting OneToMany associations to null when source is missing the property, causing error -
    // A collection with orphan deletion was no longer referenced by the owning entity instance
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputUpdateUserProfileDto dto, @MappingTarget UserProfileEntity entity);

    @AfterMapping
    default void setCV(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getCv() != null) {
            userProfile.getCv().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default void setWorkingLocation(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getWorkingLocation() != null) {
            userProfile.getWorkingLocation().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default void setReference(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getReferences() != null) {
            userProfile.getReferences().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default void setProjects(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getProjects() != null) {
            userProfile.getProjects().forEach(project -> project.setUserProfile(userProfile));
        }
    }

    @AfterMapping
    default void setPreference(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getPreferences() != null) {
            userProfile.getPreferences().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default void setExpertise(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getExpertises() != null) {
            userProfile.getExpertises().forEach(expertise -> expertise.setUserProfile(userProfile));
        }
    }

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault = true)
    @Mapping(target = "imageUrl", source = "imageUri")
    @Mapping(target = "cv", source = "inputCVDto")
    @Mapping(target = "language", source = "language")
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "emailConsent", source = "emailConsent")
    @Mapping(target = "hidePanel", source = "hidePanel")
    void patchEntity(InputPatchUserProfileDto dto, @MappingTarget UserProfileEntity entity);


    @Mapping(target = "imageUri", source = "imageUrl")
    @Mapping(target = "outputCVDto.fileUrl", source = "cv.fileUrl")
    @Mapping(target = "outputCVDto.filename", source = "cv.filename")
    @Mapping(target = "outputCVDto.size", source = "cv.size")
    @Mapping(target = "language", source = "language")
    @Mapping(target = "emailConsent", source = "emailConsent")
    @Mapping(target = "hidePanel", source = "hidePanel")
    OutputPatchUserProfileDto toPatchUserDto(UserProfileEntity entity);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault = true)
    @Mapping(target = "publicProfile", source = "publicProfile")
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    void patchEntity(InputUserProfileStatusChangeDto dto, @MappingTarget UserProfileEntity entity);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault = true)
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "publicProfile", source = "publicProfile")
    void patchEntity(InputAdminPatchUserProfileDto dto, @MappingTarget UserProfileEntity entity);

    OutputAdminPatchUserProfileDto toAdminPatchUserProfileDto(UserProfileEntity entity);

    default String map(URI uri) {
        return uri == null ? null : uri.toString();
    }

    default URI map(String uriString) {
        return uriString == null ? null : URI.create(uriString);
    }
}
