package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO for a work location.
 */
@Schema(name = "OutputWorkingLocationDto", description = "DTO representing a working location in responses")
@Data
@Builder
@AllArgsConstructor
public class OutputWorkingLocationDto {

    @Schema(description = "City", example = "Palo Alto")
    private String city;

    @Schema(description = "Region or State", example = "CA")
    private String region;

    @Schema(description = "Country", example = "USA")
    private String country;

    @Schema(description = "ZipCode", example = "90100")
    private String zipCode;
}

