package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.UUID;

/**
 * DTO for an endorsement input.
 */
@Schema(name = "OutputEndorsementAcknowledgementDto", description = "DTO representing an endorsement acknowledgement")
@Data
@Builder
@AllArgsConstructor
public class OutputEndorsementAcknowledgementDto {

    @Schema(description = "Unique identifier of the endorsement", example = "550e8400-e29b-41d4-a716-446655441001")
    private UUID id;

    @Schema(description = "Unique identifier of the user providing the endorsement", example = "550e8400-e29b-41d4-a716-446655440001")
    private UUID endorserId;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "Short biography of the user", example = "Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;

    @Schema(description = "Unique identifier of the user receiving the endorsement", example = "550e8400-e29b-41d4-a716-446655440002")
    private UUID endorsedId;

    @Schema(description = "Unique identifier of the expertise being endorsed", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID expertiseId;

    @Schema(description = "Display name of the expertise (e.g., skill name)", example = "Java Development")
    private String expertiseDisplayName;

    @Schema(description = "The creation time of the table record", example = "2025-08-25T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The update time of the table record", example = "2025-08-25T15:29:06.254836Z")
    private Instant updateTime;

}
