package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * DTO for adding user profile info for provided ids.
 */
@Schema(name = "AddProjectsToUserProfilesDto", description = "DTO for adding project to user profile for provided ids")
@Data
@Builder
@AllArgsConstructor
public class InputAddProjectToUserProfilesDto {

    @NotEmpty
    @Schema(
            description = "Ids of the user profiles to update",
            example ="[\"550e8400-e29b-41d4-a716-446655440000\", \"550e8400-e29b-41d4-a716-446655449999\"]")
    List<UUID> userIds;

    @NotNull
    @Valid
    private InputProjectDto project;
}
