package com.finconsgroup.itserr.marketplace.userprofile.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.dm.api.EndorsementApi;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.EndorsementService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user endorsement related API requests.
 *
 * <p>Implements the {@link EndorsementApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class EndorsementController implements EndorsementApi {

    private final EndorsementService endorsementService;

    @Override
    public OutputEndorsementAcknowledgementDto addEndorsement(UUID profileId, UUID expertiseId) {
        return endorsementService.addEndorsement(JwtTokenHolder.getUserIdOrThrow(), profileId, expertiseId);
    }

    @Override
    public void removeEndorsement(UUID profileId, UUID expertiseId) {
        endorsementService.removeEndorsement(JwtTokenHolder.getUserIdOrThrow(), profileId, expertiseId);
    }
}
