/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsement;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsementApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.UserProfileEndorsementMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.EventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class MessagingUserProfileEndorsementApplicationEventListener
implements ApplicationListener<UserProfileEndorsementApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingUserProfileEndorsementApplicationEventListener.class);
    private final EventProducer eventProducer;
    private final UserProfileMapper userProfileMapper;

    public void onApplicationEvent(@NonNull UserProfileEndorsementApplicationEvent event) {
        MessagingEventDto messagingEventDto = this.userProfileMapper.toMessagingEventDto(event.getUserProfileEndorsement());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        UserProfileEndorsement userProfileEndorsement = event.getUserProfileEndorsement();
        messagingEventDto.setTimestamp(userProfileEndorsement.getTimestamp());
        UserProfileEndorsementMessagingAdditionalDataDto additionalData = new UserProfileEndorsementMessagingAdditionalDataDto();
        additionalData.setNotifyUserIds(userProfileEndorsement.getNotifyUserIds());
        additionalData.setExpertiseId(userProfileEndorsement.getExpertiseId());
        additionalData.setExpertiseDisplayName(userProfileEndorsement.getExpertiseDisplayName());
        messagingEventDto.setAdditionalData((Object)additionalData);
        this.eventProducer.publishEndorsementEvent(messagingEventDto);
    }

    @Generated
    public MessagingUserProfileEndorsementApplicationEventListener(EventProducer eventProducer, UserProfileMapper userProfileMapper) {
        this.eventProducer = eventProducer;
        this.userProfileMapper = userProfileMapper;
    }
}

