package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto;

import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.UUID;

@Data
@Builder
public class MemberInvitationStatusChangeNotificationData {

    /**
     * Indicates whether the request has been approved or rejected by the member
     * Approval status (true = approved, false = rejected)
     */
    private Boolean approved;

    /**
     * Message explaining approval/rejection
     */
    private String message;

    /**
     * True, if the user is invited as wp leader
     */
    private Boolean wpLeader;

    /**
     * ID of the invited user
     */
    private UUID invitedUser;

    /**
     * Root institutional page identifier
     */
    private UUID rootInstitutionalPageId;

    /**
     * Root institutional page display name
     */
    private String rootInstitutionalPageName;

    /**
     * User IDs of members to notify
     */
    private List<UUID> notifyUserIds;

    /**
     * Map of Ids and names of all associated institutional pages in the hierarchy
     * including the root institutional page
     */
    private Map<UUID, String> hierarchyInstitutionalPages;
}