/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ExecutionException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsement;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileEndorsementApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterests;
import com.finconsgroup.itserr.marketplace.userprofile.bs.bean.UserProfileInterestsApplicationEvent;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.SocialNetworkingD4SClient;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.WorkspaceBsClient;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAddProjectToUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputCreateDocumentDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputFindUserProfilesByInterestsDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputPatchUserProfileProjectDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.InputRemoveProjectFromUserProfilesDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputCreatedDocumentDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputDocumentPublicLinkDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputUserProfileFolderDetails;
import com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto.OutputUsernameListD4SDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.FolderDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputCVDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputFolderCreateDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserSettingDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.WorkspaceDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.userprofile.bs.exception.UserProfileAlreadyExistsException;
import com.finconsgroup.itserr.marketplace.userprofile.bs.exception.UserProfileNotFoundException;
import com.finconsgroup.itserr.marketplace.userprofile.bs.mapper.UserProfileSettingMapper;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;
import com.finconsgroup.itserr.marketplace.userprofile.bs.util.Constants;
import com.finconsgroup.itserr.marketplace.userprofile.bs.util.Language;
import com.finconsgroup.itserr.marketplace.userprofile.bs.util.UniqueFilenameGenerator;
import feign.FeignException;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DefaultUserProfileService
implements UserProfileService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserProfileService.class);
    public static final String D4S_RETRIEVE_USER_EXCEPTION = "Issue while retrieving users";
    private static final String D4S_RETRIEVE_USER_NOT_FOUND_MESSAGE = "HTTP 404";
    private final UserProfileDmClient userProfileDmClient;
    private final WorkspaceBsClient workspaceBsClient;
    private final SocialNetworkingD4SClient socialNetworkingD4SClient;
    private final UserProfileSettingMapper settingMapper;
    private final ApplicationEventPublisher applicationEventPublisher;

    @NonNull
    public URI uploadImage(@NonNull MultipartFile image) {
        OutputUserProfileFolderDetails userProfileFolderDetails = this.profileFolderRetriever();
        String fileName = UniqueFilenameGenerator.generate((String)image.getOriginalFilename());
        InputCreateDocumentDto imageData = InputCreateDocumentDto.builder().name(fileName).description("Profile Image").build();
        OutputCreatedDocumentDto documentDto = this.workspaceBsClient.createDocument(userProfileFolderDetails.getUserProfileFolderId().toString(), imageData);
        this.workspaceBsClient.uploadNewContent(documentDto.getId(), fileName, image.getResource());
        OutputDocumentPublicLinkDto outputDocumentPublicLinkDto = this.workspaceBsClient.getPublicLink(documentDto.getId());
        InputPatchUserProfileDto inputPatchUserProfileDto = InputPatchUserProfileDto.builder().imageUri(outputDocumentPublicLinkDto.getPublicLink()).build();
        OutputPatchUserProfileDto outputPatchUserProfileDto = this.userProfileDmClient.patchUserProfile(inputPatchUserProfileDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.findById(), MessagingEventType.IMAGE_UPDATED));
        return outputPatchUserProfileDto.getImageUri();
    }

    @NonNull
    public URI uploadCv(@NonNull MultipartFile cvFile) {
        OutputUserProfileFolderDetails userProfileFolderDetails = this.profileFolderRetriever();
        String fileName = UniqueFilenameGenerator.generate((String)cvFile.getOriginalFilename());
        InputCreateDocumentDto cvData = InputCreateDocumentDto.builder().name(fileName).description("Personal Cv").build();
        OutputCreatedDocumentDto documentDto = this.workspaceBsClient.createDocument(userProfileFolderDetails.getUserProfileFolderId().toString(), cvData);
        this.workspaceBsClient.uploadNewContent(documentDto.getId(), fileName, cvFile.getResource());
        OutputDocumentPublicLinkDto outputDocumentPublicLinkDto = this.workspaceBsClient.getPublicLink(documentDto.getId());
        InputPatchUserProfileDto inputPatchUserProfileDto = InputPatchUserProfileDto.builder().inputCVDto(InputCVDto.builder().fileUrl(String.valueOf(outputDocumentPublicLinkDto.getPublicLink())).filename(cvData.getName()).size(cvFile.getSize()).build()).build();
        OutputPatchUserProfileDto patchUserProfileDto = this.userProfileDmClient.patchUserProfile(inputPatchUserProfileDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.findById(), MessagingEventType.CV_UPDATED));
        return URI.create(patchUserProfileDto.getOutputCVDto().getFileUrl());
    }

    private OutputUserProfileFolderDetails profileFolderRetriever() {
        return Optional.ofNullable(this.userProfileDmClient.getProfileFolder()).orElseThrow(() -> new WP2ResourceNotFoundException("Profile folder not exist"));
    }

    @NonNull
    public OutputUserProfileDto create(@NonNull UUID userId, @NonNull InputUserProfileDto inputUserProfileDto) {
        try {
            UUID folderId = this.getOrCreateHiddenFolder(userId);
            inputUserProfileDto.setUserProfileFolderId(folderId);
            OutputUserProfileDto outputUserProfileDto = this.userProfileDmClient.create(inputUserProfileDto);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(outputUserProfileDto, MessagingEventType.CREATED));
            UserProfileInterests userProfileInterests = UserProfileInterests.builder().id(outputUserProfileDto.getId()).name(outputUserProfileDto.getFirstName() + " " + outputUserProfileDto.getLastName()).timestamp(outputUserProfileDto.getCreationTime().toInstant()).build();
            List<String> expertises = Optional.ofNullable(outputUserProfileDto.getExpertises()).orElse(List.of()).stream().map(OutputExpertiseDto::getDisplayName).toList();
            this.publishInterestsEvent(userProfileInterests, expertises, Set.of(userId));
            return outputUserProfileDto;
        }
        catch (FeignException.Conflict e) {
            throw new UserProfileAlreadyExistsException(userId);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    private UUID getOrCreateHiddenFolder(UUID userId) {
        WorkspaceDto workspace = this.getUserWorkspace();
        try {
            FolderDto folder = this.getUserProfileFolderId(workspace.getId());
            return UUID.fromString(folder.getId());
        }
        catch (FeignException.NotFound e) {
            String newFolderId = this.createUserProfileFolder(workspace.getId());
            log.info("Created hidden folder for user: {} with folder ID: {}", (Object)userId, (Object)newFolderId);
            return UUID.fromString(newFolderId);
        }
    }

    @NonNull
    public WorkspaceDto getUserWorkspace() {
        return this.workspaceBsClient.getWorkspace();
    }

    @NonNull
    public OutputUserProfileDto getById(@NonNull UUID userId) {
        try {
            return this.userProfileDmClient.getById(userId);
        }
        catch (FeignException.NotFound e) {
            throw new UserProfileNotFoundException(userId);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @NonNull
    public OutputUserProfileDto updateById(@NonNull UUID userId, @NonNull InputUpdateUserProfileDto inputUpdateUserProfileDto) {
        try {
            OutputUserProfileDto outputUserProfileDto = this.userProfileDmClient.updateById(inputUpdateUserProfileDto);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(outputUserProfileDto, MessagingEventType.UPDATED));
            return outputUserProfileDto;
        }
        catch (FeignException.NotFound e) {
            throw new UserProfileNotFoundException(userId);
        }
        catch (Exception e) {
            throw new WP2ExecutionException((Throwable)e);
        }
    }

    @NonNull
    public FolderDto getUserProfileFolderId(@NonNull String folderId) {
        return this.workspaceBsClient.getFolderByParentFolderIdAndName(folderId, "myProfile");
    }

    @NonNull
    public String createUserProfileFolder(@NonNull String parentFolderId) {
        return this.workspaceBsClient.createFolderByFolderId(parentFolderId, this.getHiddenFolderPayload());
    }

    @NonNull
    public OutputUserSettingDto updateLanguage(String language) {
        language = Language.fromString((String)language).toString();
        InputPatchUserProfileDto inputPatchUserProfileDto = InputPatchUserProfileDto.builder().language(language).build();
        OutputPatchUserProfileDto patchUserProfileDto = this.userProfileDmClient.patchUserProfile(inputPatchUserProfileDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.findById(), MessagingEventType.LANGUAGE_UPDATED));
        return this.settingMapper.patchedUserToSetting(patchUserProfileDto);
    }

    @NonNull
    public List<OutputUserProfileDto> getUserProfilesByRole(String roleName) {
        OutputUsernameListD4SDto outputUsernameListD4SDto = null;
        try {
            outputUsernameListD4SDto = this.socialNetworkingD4SClient.getUsernamesByRole(roleName);
            if (outputUsernameListD4SDto == null || !outputUsernameListD4SDto.isSuccess()) {
                if (outputUsernameListD4SDto == null || StringUtils.isBlank((CharSequence)outputUsernameListD4SDto.getMessage())) {
                    throw new WP2BusinessException(D4S_RETRIEVE_USER_EXCEPTION);
                }
                throw new WP2BusinessException(outputUsernameListD4SDto.getMessage());
            }
        }
        catch (FeignException.InternalServerError e) {
            if (e.getMessage().contains(D4S_RETRIEVE_USER_NOT_FOUND_MESSAGE)) {
                log.error("Users not found for roleName - {}", (Object)roleName, (Object)e);
            }
            throw e;
        }
        if (outputUsernameListD4SDto != null && outputUsernameListD4SDto.getResult() != null && !outputUsernameListD4SDto.getResult().isEmpty()) {
            List outputUserProfileDtos = this.userProfileDmClient.findAllByPrincipals(InputFindUserProfilesByPrincipalsDto.builder().principals(outputUsernameListD4SDto.getResult()).build(), 0, outputUsernameListD4SDto.getResult().size(), "id", SortDirection.ASC).getContent();
            Set foundPrincipals = outputUserProfileDtos.stream().map(OutputUserProfileDto::getPreferredUsername).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            HashSet missingPrincipals = new HashSet(outputUsernameListD4SDto.getResult());
            missingPrincipals.removeAll(foundPrincipals);
            if (!missingPrincipals.isEmpty()) {
                log.debug("UserProfiles not found following principals with role {} - {}", (Object)roleName, missingPrincipals);
            }
            return outputUserProfileDtos;
        }
        return List.of();
    }

    @NonNull
    public void addProjectToUserProfiles(InputAddProjectToUserProfilesDto inputAddProjectToUserProfilesDto) {
        List outputUserProfileDtos = this.userProfileDmClient.addProjectToUserProfiles(inputAddProjectToUserProfilesDto);
        outputUserProfileDtos.forEach(outputUserProfileDto -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(outputUserProfileDto, MessagingEventType.UPDATED)));
    }

    @NonNull
    public void removeProjectFromUserProfiles(InputRemoveProjectFromUserProfilesDto inputRemoveProjectFromUserProfilesDto) {
        List outputUserProfileDtos = this.userProfileDmClient.removeProjectFromUserProfiles(inputRemoveProjectFromUserProfilesDto);
        outputUserProfileDtos.forEach(outputUserProfileDto -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(outputUserProfileDto, MessagingEventType.UPDATED)));
    }

    @NonNull
    public void patchUserProfileProject(InputPatchUserProfileProjectDto inputPatchUserProfileProjectDto) {
        List outputUserProfileDtos = this.userProfileDmClient.patchUserProfileProject(inputPatchUserProfileProjectDto);
        outputUserProfileDtos.forEach(outputUserProfileDto -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(outputUserProfileDto, MessagingEventType.UPDATED)));
    }

    @NonNull
    public OutputAdminPatchUserProfileDto patchUserProfile(UUID profileId, InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto) {
        OutputAdminPatchUserProfileDto dto = this.userProfileDmClient.patchUserProfile(profileId, inputAdminPatchUserProfileDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.getById(profileId), MessagingEventType.UPDATED));
        return dto;
    }

    public void processUserProfileStatusChange(@NonNull UUID userId, @NonNull Boolean active) {
        if (active.booleanValue()) {
            this.userProfileDmClient.activate();
        } else {
            this.userProfileDmClient.deactivate();
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.getById(userId), MessagingEventType.UPDATED));
    }

    public void publishAllProfilesMessages() {
        OutputPageDto userProfilesPage;
        int pageNumber = 0;
        long fetchedCount = 0L;
        while ((userProfilesPage = this.userProfileDmClient.findAll(pageNumber, 50, "id", SortDirection.ASC)).getContent() != null && !userProfilesPage.getContent().isEmpty()) {
            userProfilesPage.getContent().forEach(userProfileDto -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(userProfileDto, MessagingEventType.UPDATED)));
            long totalCount = userProfilesPage.getPage().getTotalElements();
            if (totalCount <= (fetchedCount += (long)userProfilesPage.getContent().size())) break;
            ++pageNumber;
        }
    }

    public void publishInterestsEvent(@NonNull UserProfileInterests userProfileInterests, @Nullable List<String> stringsToCheck, @NonNull Set<UUID> userIdsToExclude) {
        if (stringsToCheck == null || stringsToCheck.isEmpty()) {
            return;
        }
        List userProfileIdsWithInterests = this.userProfileDmClient.findMatchingInterests(InputFindUserProfilesByInterestsDto.builder().stringsToCheck(stringsToCheck).build());
        if (userProfileIdsWithInterests == null || userProfileIdsWithInterests.isEmpty()) {
            return;
        }
        userProfileInterests.setNotifyUserIds(new LinkedHashSet(userProfileIdsWithInterests));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileInterestsApplicationEvent(userProfileInterests, MessagingEventType.INTERESTS));
    }

    private InputFolderCreateDto getHiddenFolderPayload() {
        return InputFolderCreateDto.builder().name("myProfile").description("Containing info about the current user profile").hidden(Constants.HIDDEN_FOLDER_HIDDEN_FLAG).build();
    }

    @NonNull
    public Boolean updateHidePanel(Boolean hidePanel) {
        InputPatchUserProfileDto inputPatchUserProfileDto = InputPatchUserProfileDto.builder().hidePanel(hidePanel).build();
        OutputPatchUserProfileDto patchUserProfileDto = this.userProfileDmClient.patchUserProfile(inputPatchUserProfileDto);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.findById(), MessagingEventType.UPDATED));
        return patchUserProfileDto.getHidePanel();
    }

    @NonNull
    public OutputEndorsementAcknowledgementDto addEndorsement(UUID profileId, UUID expertiseId) {
        OutputEndorsementAcknowledgementDto dto = this.userProfileDmClient.addEndorsement(profileId, expertiseId);
        OutputUserProfileDto userProfileDto = this.userProfileDmClient.getById(profileId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(userProfileDto, MessagingEventType.UPDATED));
        UserProfileEndorsement userProfileEndorsement = UserProfileEndorsement.builder().id(dto.getId()).name(userProfileDto.getFirstName() + " " + userProfileDto.getLastName()).title(userProfileDto.getPreferredUsername()).notifyUserIds(Set.of(dto.getEndorsedId())).expertiseId(dto.getExpertiseId()).expertiseDisplayName(dto.getExpertiseDisplayName()).timestamp(dto.getCreationTime()).build();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileEndorsementApplicationEvent(userProfileEndorsement, MessagingEventType.ENDORSEMENT));
        return dto;
    }

    @NonNull
    public void removeEndorsement(UUID profileId, UUID expertiseId) {
        this.userProfileDmClient.removeEndorsement(profileId, expertiseId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new UserProfileApplicationEvent(this.userProfileDmClient.getById(profileId), MessagingEventType.UPDATED));
    }

    @Generated
    public DefaultUserProfileService(UserProfileDmClient userProfileDmClient, WorkspaceBsClient workspaceBsClient, SocialNetworkingD4SClient socialNetworkingD4SClient, UserProfileSettingMapper settingMapper, ApplicationEventPublisher applicationEventPublisher) {
        this.userProfileDmClient = userProfileDmClient;
        this.workspaceBsClient = workspaceBsClient;
        this.socialNetworkingD4SClient = socialNetworkingD4SClient;
        this.settingMapper = settingMapper;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

