package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * An updated document.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "UpdatedDocument",
        description = "Represents an updated document"
)
public class OutputUpdatedDocumentDto {

    @Schema(
            description = "Document Id",
            example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(description = "Document name")
    private String name;

    @Schema(description = "Document description")
    private String description;

}
