package com.finconsgroup.itserr.marketplace.userprofile.bs.bean;

import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when an endorsement has been created.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class UserProfileEndorsementApplicationEvent extends ApplicationEvent {
    private final MessagingEventType eventType;
    private final Instant eventTimestamp;

    public UserProfileEndorsementApplicationEvent(@NonNull UserProfileEndorsement source,
                                                  @NonNull MessagingEventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The user profile on which event occurred
     *
     * @return the {@link OutputUserProfileDto}
     */
    public UserProfileEndorsement getUserProfileEndorsement() {
        return (UserProfileEndorsement) getSource();
    }
}
