package com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.dto;

import com.finconsgroup.itserr.marketplace.userprofile.bs.messaging.enums.OperationType;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

@Data
@Builder
public class InstitutionalPageStatusChangeNotificationData {

    /**
     * Approval status set by admin (true = approved, false = rejected)
     */
    private Boolean approved;

    /**
     * Type of operation being performed
     */
    private OperationType operationType;

    /**
     * Admin's comment or reason for decision
     */
    private String message;

    /**
     * Whether the content is published
     */
    private Boolean published;

    /**
     * list of WP leader user IDs
     */
    private List<UUID> currentWpLeaders;

    /**
     * list of member user IDs
     */
    private List<UUID> currentMembers;

    /**
     * Root institutional page identifier
     */
    private UUID rootInstitutionalPageId;

    /**
     * Name of the root institutional page
     */
    private String rootInstitutionalPageName;

    /**
     * list of Ids to notify
     */
    private List<UUID> notifyUserIds;
}