package com.finconsgroup.itserr.marketplace.userprofile.bs.bean;

import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when a user action is taken on User Profile.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class UserProfileApplicationEvent extends ApplicationEvent {
    private final  MessagingEventType eventType;
    private final Instant eventTimestamp;

    public UserProfileApplicationEvent(@NonNull OutputUserProfileDto source,
                                       @NonNull MessagingEventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The user profile on which event occurred
     *
     * @return the {@link OutputUserProfileDto}
     */
    public OutputUserProfileDto getUserProfileDto() {
        return (OutputUserProfileDto) getSource();
    }
}
