package com.finconsgroup.itserr.marketplace.userprofile.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.bs.api.UserProfileApi;

import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.dto.OutputUserSettingDto;
import com.finconsgroup.itserr.marketplace.userprofile.bs.service.UserProfileService;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.net.URI;
import java.util.List;
import java.util.UUID;

/**
 * REST controller for handling UserProfile-related API requests.
 *
 * <p>Implements the {@link UserProfileApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class UserProfileController implements UserProfileApi {

    private final UserProfileService userProfileService;

    @Override
    public OutputUserProfileDto create(InputUserProfileDto inputUserProfileDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return userProfileService.create(userId, inputUserProfileDto);
    }

    @Override
    public OutputUserProfileDto updateById(InputUpdateUserProfileDto inputUpdateUserProfileDto) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return userProfileService.updateById(userId, inputUpdateUserProfileDto);
    }

    @Override
    public URI uploadImage(MultipartFile image) {
        return this.userProfileService.uploadImage(image);
    }

    @Override
    public URI uploadCv(MultipartFile cvFile) {
        return this.userProfileService.uploadCv(cvFile);
    }

    @Override
    public OutputUserSettingDto updateLanguage(String language) {
        return this.userProfileService.updateLanguage(language);
    }

    @Override
    public List<OutputUserProfileDto> getUserProfilesByRole(String roleName) {
        return userProfileService.getUserProfilesByRole(roleName);
    }

    @Override
    public void activate() {
        userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), true);
    }

    @Override
    public void deactivate() {
        userProfileService.processUserProfileStatusChange(JwtTokenHolder.getUserIdOrThrow(), false);
    }

    @Override
    public Boolean updateHidePanel(Boolean hidePanel) {
        return userProfileService.updateHidePanel(hidePanel);
    }
}
