package com.finconsgroup.itserr.marketplace.userprofile.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.net.URI;

/**
 * An object containing the public link to a document.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "DocumentPublicLink",
        description = "Contains the public link to a document"
)
public class OutputDocumentPublicLinkDto {

    @Schema(
            description = "Document Id",
            example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(description = """
            Public link to the document.<br>
            Anyone having this link, also if not authenticated / authorized, can read the document.
            """)
    private URI publicLink;

}
