/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.UserRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl.AbstractSessionManagementService;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnProperty(prefix="user-communication.dm.web-socket", value={"enable-broker-relay"}, havingValue="true")
@Service
public class ExternalBrokerSessionManagementService
extends AbstractSessionManagementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalBrokerSessionManagementService.class);
    private final SimpUserRegistry userRegistry;
    private final Map<String, WebSocketUser> userBySessionId = new ConcurrentHashMap();

    public ExternalBrokerSessionManagementService(SimpUserRegistry userRegistry, UserRepository userRepository) {
        super(userRepository);
        this.userRegistry = userRegistry;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User onSessionCreated(@NonNull String sessionId, @NonNull WebSocketUser user) {
        boolean isFirstSession;
        UUID userId = user.getUserId();
        this.userBySessionId.put(sessionId, user);
        int otherSessionCount = this.getSessionCount(userId, sessionId);
        boolean bl = isFirstSession = otherSessionCount == 0;
        if (isFirstSession) {
            log.info("User {} came online with session {}", (Object)userId, (Object)sessionId);
            return this.updateUserOnlineStatus(user, true);
        }
        log.info("User {} (session: {}, total sessions: {})", new Object[]{userId, sessionId, otherSessionCount + 1});
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User onSessionDestroyed(@NonNull String sessionId) {
        WebSocketUser user = (WebSocketUser)this.userBySessionId.remove(sessionId);
        if (user != null) {
            boolean isLastSession;
            UUID userId = user.getUserId();
            int otherSessionCount = this.getSessionCount(userId, sessionId);
            boolean bl = isLastSession = otherSessionCount == 0;
            if (isLastSession) {
                log.info("User {} went offline (session: {})", (Object)userId, (Object)sessionId);
                return this.updateUserOnlineStatus(user, false);
            }
            log.info("User {} disconnected session {} (remaining sessions: {})", new Object[]{userId, sessionId, otherSessionCount});
        }
        return null;
    }

    public boolean isUserOnline(@NonNull UUID userId) {
        return this.userRegistry.getUser(userId.toString()) != null;
    }

    public int getUserSessionCount(@NonNull UUID userId) {
        return this.getSessionCount(userId, null);
    }

    private int getSessionCount(@NonNull UUID userId, @Nullable String ignoreSessionId) {
        String sessionUsername = userId.toString();
        int sessionCounter = 0;
        for (SimpUser userRegistryUser : this.userRegistry.getUsers()) {
            if (!sessionUsername.equals(userRegistryUser.getName())) continue;
            int sessionCount = ignoreSessionId != null ? (int)userRegistryUser.getSessions().stream().filter(s -> !ignoreSessionId.equals(s.getId())).count() : userRegistryUser.getSessions().size();
            sessionCounter += sessionCount;
        }
        return sessionCounter;
    }
}

