/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.security;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketAuthentication;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.PreConditionService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;

public final class SubscriptionAuthorizationChannelInterceptor
implements ChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionAuthorizationChannelInterceptor.class);
    private static final String INVALID_CONVERSATION_ID = "<NOT_VALID>";
    private final PreConditionService preConditionService;
    private final MessageDestinations messageDestinations;

    public Message<?> preSend(@NonNull Message<?> message, @NonNull MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (accessor != null && StompCommand.SUBSCRIBE.equals((Object)accessor.getCommand())) {
            WebSocketAuthentication authentication = (WebSocketAuthentication)accessor.getUser();
            UUID sessionUserId = authentication.getPrincipal().getUserId();
            String destination = accessor.getDestination();
            if (destination != null && !this.checkTopicConversationDestination(sessionUserId, destination)) {
                return null;
            }
        }
        return message;
    }

    private boolean checkTopicConversationDestination(UUID sessionUserId, String destination) {
        UUID conversationId = null;
        if (this.messageDestinations.isTopicConversation(destination)) {
            try {
                conversationId = this.messageDestinations.extractConversationId(destination);
                this.preConditionService.checkUserAndConversation(sessionUserId, conversationId);
            }
            catch (Exception e) {
                log.warn("User {} attempted to subscribe to destination {} for conversation {} and failed with {}", new Object[]{sessionUserId, destination, conversationId == null ? INVALID_CONVERSATION_ID : conversationId, e.getMessage()});
                return false;
            }
        }
        return true;
    }

    @Generated
    public SubscriptionAuthorizationChannelInterceptor(PreConditionService preConditionService, MessageDestinations messageDestinations) {
        this.preConditionService = preConditionService;
        this.messageDestinations = messageDestinations;
    }
}

