/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, UUID> {
    @NonNull
    public Optional<User> findById(@NonNull UUID var1);

    public List<User> findByOnlineTrue();

    @Modifying
    @Query(value="UPDATE User u SET u.online = :online, u.lastSeen = :lastSeen WHERE u.id = :userId")
    public void updateOnlineStatus(@Param(value="userId") UUID var1, @Param(value="online") boolean var2, @Param(value="lastSeen") Instant var3);

    @Query(value="SELECT u FROM User u WHERE u.online = true OR u.lastSeen >= :since ORDER BY u.lastSeen DESC")
    public List<User> findRecentlyActiveUsers(@Param(value="since") Instant var1);
}

