/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public interface ChatMessageRepository
extends JpaRepository<ChatMessage, UUID> {
    @NonNull
    public Optional<ChatMessage> findById(@NonNull UUID var1);

    @NonNull
    public List<ChatMessage> findByIdInAndConversationId(@NonNull Collection<UUID> var1, @NonNull UUID var2);

    public List<ChatMessage> findByConversationIdOrderByCreatedAtAsc(UUID var1);

    @Query(value="SELECT new com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto(cm.conversationId, count(cm)) FROM ChatMessage cm WHERE cm.conversationId in (:conversationIds) GROUP BY cm.conversationId")
    public List<OutputConversationMessageSummaryDto> countByConversationId(Set<UUID> var1);

    @Query(value="WITH messages AS (SELECT cm.*, rank() OVER (PARTITION BY cm.conversation_id ORDER by cm.created_at DESC) message_rank FROM chat_messages cm WHERE cm.conversation_id IN (:conversationIds))SELECT messages.* FROM messages WHERE message_rank = 1", nativeQuery=true)
    public List<ChatMessage> findLatestByConversationIdIn(Set<UUID> var1);

    @Query(value="SELECT new com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationMessageSummaryDto(\ncm.conversationId, COUNT(cm)) FROM ChatMessage cm\nWHERE cm.conversationId IN (:conversationIds)\nAND cm.senderId <> :userId\nAND cm.readAt IS NULL\nGROUP BY cm.conversationId\n")
    public List<OutputConversationMessageSummaryDto> countUnreadByConversationIdIn(@Param(value="userId") UUID var1, @Param(value="conversationIds") Set<UUID> var2);

    @Query(value="    WITH messages AS (SELECT cm.*,\n    rank() OVER (PARTITION BY cm.conversation_id ORDER by cm.created_at) message_rank\n    FROM chat_messages cm\n    WHERE cm.conversation_id IN (:conversationIds)\n    AND cm.sender_id <> :userId\n    AND cm.read_at IS NULL)\n    SELECT messages.* FROM messages WHERE message_rank = 1\n", nativeQuery=true)
    public List<ChatMessage> findEarliestUnreadByConversationIdIn(@Param(value="userId") UUID var1, @Param(value="conversationIds") Set<UUID> var2);

    public List<ChatMessage> findBySenderIdOrderByCreatedAtDesc(UUID var1);

    public Page<ChatMessage> findMessagesByConversationId(UUID var1, Pageable var2);

    public List<ChatMessage> findMessagesByConversationIdAndIdIn(UUID var1, List<UUID> var2);

    @Query(value="SELECT cm FROM ChatMessage cm\nJOIN Conversation c on c.id = cm.conversationId\nWHERE c.active = true\nAND LOWER(cm.content) LIKE LOWER(CONCAT('%', :term, '%'))\nAND EXISTS (\n       SELECT 1 FROM ConversationParticipant cp\n       WHERE cp.conversationId = c.id\n       AND cp.userId = :userId\n       AND cp.active = true\n)")
    public Page<ChatMessage> findByContentContainingIgnoreCase(@Param(value="userId") UUID var1, @Param(value="term") String var2, Pageable var3);

    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE ChatMessage cm SET cm.readByReceiver = true, cm.readAt = :readAt WHERE cm.id = :messageId AND cm.receiverId = :receiverId")
    public int markMessageAsReadByReceiver(@Param(value="messageId") String var1, @Param(value="receiverId") UUID var2, @Param(value="readAt") Instant var3);

    @Query(value="SELECT cm.id FROM ChatMessage cm\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false\n")
    public List<UUID> getConversationMessagesToMarkAsRead(@Param(value="conversationId") UUID var1, @Param(value="receiverId") UUID var2, @Param(value="readAt") Instant var3);

    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE ChatMessage cm SET cm.readByReceiver = true, cm.readAt = :readAt\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false\n")
    public int markConversationMessagesAsRead(@Param(value="conversationId") UUID var1, @Param(value="receiverId") UUID var2, @Param(value="readAt") Instant var3);

    @Query(value="SELECT cm.id FROM ChatMessage cm\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false AND cm.createdAt <= :uptoCreatedAt\n")
    public List<UUID> getConversationMessagesUptoCreatedAtToMarkAsRead(@Param(value="conversationId") UUID var1, @Param(value="uptoCreatedAt") Instant var2, @Param(value="receiverId") UUID var3, @Param(value="readAt") Instant var4);

    @Modifying(flushAutomatically=true)
    @Query(value="UPDATE ChatMessage cm SET cm.readByReceiver = true, cm.readAt = :readAt\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false AND cm.createdAt <= :uptoCreatedAt\n")
    public int markConversationMessagesUptoCreatedAtAsRead(@Param(value="conversationId") UUID var1, @Param(value="uptoCreatedAt") Instant var2, @Param(value="receiverId") UUID var3, @Param(value="readAt") Instant var4);

    @Query(value="SELECT cm.id FROM ChatMessage cm\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false AND cm.id IN (:ids)\n")
    public List<UUID> getConversationMessagesByIdInToMarkAsRead(@Param(value="conversationId") UUID var1, @Param(value="ids") Set<UUID> var2, @Param(value="receiverId") UUID var3, @Param(value="readAt") Instant var4);

    @Modifying
    @Query(value="UPDATE ChatMessage cm SET cm.readByReceiver = true, cm.readAt = :readAt\nWHERE cm.conversationId = :conversationId AND cm.receiverId = :receiverId\nAND cm.readByReceiver = false AND cm.id IN (:ids)\n")
    public int markConversationMessagesByIdInAsRead(@Param(value="conversationId") UUID var1, @Param(value="ids") Set<UUID> var2, @Param(value="receiverId") UUID var3, @Param(value="readAt") Instant var4);

    @Modifying
    @Query(value="  with max_index as (\n  select\n    conversation_id,\n    coalesce(max(message_index), 0) as max_index\n  from\n    chat_messages\n  where\n    conversation_id = :conversationId\n    and message_index is not null\n  group by\n    conversation_id\n  ),\n  messages_with_index as (\n  select\n    cm.id,\n    cm.conversation_id,\n    row_number() over(partition by cm.conversation_id order by cm.created_at, cm.id) as message_index,\n    coalesce(max_index.max_index, 0) as max_index\n  from\n    chat_messages cm\n  left join max_index on\n    max_index.conversation_id = cm.conversation_id\n  where\n    cm.conversation_id = :conversationId\n    and message_index is null\n  )\n  update\n    chat_messages\n  set\n    message_index = messages_with_index.max_index + messages_with_index.message_index\n  from\n    messages_with_index\n  where\n    chat_messages.conversation_id = :conversationId\n    and chat_messages.id = messages_with_index.id\n", nativeQuery=true)
    public int updateMessageIndex(@Param(value="conversationId") UUID var1);
}

