/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.exception;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageHeaders;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.exception.MessagingErrorResponseDto;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class MessagingExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingExceptionHandler.class);
    private static final String VALIDATION_ERROR_ARGUMENT_SEPARATOR = ": ";
    private static final String LOG_ERROR_MESSAGE = "Error occurred for request: %s";

    @SendToUser(value={"/queue/errors"})
    @MessageExceptionHandler(value={MethodArgumentNotValidException.class})
    public MessagingErrorResponseDto handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, SimpMessageHeaderAccessor headerAccessor) {
        this.logError((Exception)ex, headerAccessor);
        LinkedList<CallSite> errors = new LinkedList<CallSite>();
        if (ex.getBindingResult() != null) {
            ex.getBindingResult().getFieldErrors().stream().map(fieldError -> {
                String fieldName = fieldError.getField();
                String errorMessage = fieldError.getDefaultMessage();
                return fieldName + VALIDATION_ERROR_ARGUMENT_SEPARATOR + errorMessage;
            }).forEach(errors::add);
            ex.getBindingResult().getGlobalErrors().stream().map(globalError -> {
                String fieldName = globalError.getObjectName();
                String errorMessage = globalError.getDefaultMessage();
                return fieldName + VALIDATION_ERROR_ARGUMENT_SEPARATOR + errorMessage;
            }).forEach(errors::add);
        } else {
            errors.add((CallSite)((Object)(ex.getMethodParameter().getParameterName() + VALIDATION_ERROR_ARGUMENT_SEPARATOR + ex.getMessage())));
        }
        return this.createError(HttpStatus.BAD_REQUEST, errors, (Exception)ex, headerAccessor);
    }

    @SendToUser(value={"/queue/errors"})
    @ExceptionHandler(value={MessagingException.class})
    public MessagingErrorResponseDto handleMessagingException(MessagingException ex, SimpMessageHeaderAccessor headerAccessor) {
        this.logError((Exception)ex, headerAccessor);
        return this.createError(HttpStatus.INTERNAL_SERVER_ERROR, "", (Exception)ex, headerAccessor);
    }

    public void logError(Exception ex, SimpMessageHeaderAccessor headerAccessor) {
        String errorMessage = LOG_ERROR_MESSAGE.formatted(headerAccessor);
        log.error(errorMessage, (Throwable)ex);
    }

    public MessagingErrorResponseDto createError(HttpStatus httpStatus, String message, Exception ex, SimpMessageHeaderAccessor headerAccessor) {
        return this.createError(httpStatus, List.of(message), ex, headerAccessor);
    }

    public MessagingErrorResponseDto createError(HttpStatus httpStatus, List<String> messages, Exception ex, SimpMessageHeaderAccessor headerAccessor) {
        String destination = headerAccessor.getDestination();
        String requestMessageId = headerAccessor.getFirstNativeHeader("requestMessageId");
        List stackTrace = log.isDebugEnabled() ? ExceptionUtils.getRootCauseStackTraceList((Throwable)ex) : null;
        MessageHeaders.USER_DESTINATION_DEFAULTS.forEach((k, v) -> headerAccessor.setNativeHeader(k, v.toString()));
        return new MessagingErrorResponseDto(httpStatus.value(), messages, destination, requestMessageId, stackTrace);
    }
}

