/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="users")
public class User
extends AbstractUUIDEntity {
    @Column(name="first_name")
    private String firstName;
    @Column(name="last_name")
    private String lastName;
    @Column(name="online", nullable=false)
    private boolean online;
    @Column(name="last_seen")
    private Instant lastSeen;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;

    public User(UUID userId) {
        this();
        this.setId(userId);
    }

    public void setOnline(boolean online) {
        this.online = online;
        if (online) {
            this.lastSeen = Instant.now();
        }
    }

    public void prePersist() {
        super.prePersist();
        this.createdAt = Instant.now();
    }

    @Generated
    protected User(UserBuilder<?, ?> b) {
        super(b);
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.online = b.online;
        this.lastSeen = b.lastSeen;
        this.createdAt = b.createdAt;
    }

    @Generated
    public static UserBuilder<?, ?> builder() {
        return new UserBuilderImpl();
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public boolean isOnline() {
        return this.online;
    }

    @Generated
    public Instant getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setLastSeen(Instant lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOnline() != other.isOnline()) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        Instant this$lastSeen = this.getLastSeen();
        Instant other$lastSeen = other.getLastSeen();
        if (this$lastSeen == null ? other$lastSeen != null : !((Object)this$lastSeen).equals(other$lastSeen)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOnline() ? 79 : 97);
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        Instant $lastSeen = this.getLastSeen();
        result = result * 59 + ($lastSeen == null ? 43 : ((Object)$lastSeen).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public User() {
    }
}

