/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatRoom;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="chat_rooms")
public class ChatRoom
extends AbstractUUIDEntity {
    @Column(name="name", nullable=false)
    @NotBlank(message="Chat room name cannot be blank")
    private @NotBlank(message="Chat room name cannot be blank") String name;
    @Column(name="description", columnDefinition="TEXT")
    private String description;
    @Column(name="created_by", nullable=false)
    private UUID createdBy;
    @Column(name="created_at", nullable=false)
    private Instant createdAt;
    @Column(name="last_activity", nullable=false)
    private Instant lastActivity;
    @ElementCollection
    @CollectionTable(name="chat_room_participants", joinColumns={@JoinColumn(name="chat_room_id")})
    @Column(name="user_id")
    private Set<UUID> participants;
    @Column(name="active", nullable=false)
    private boolean active;
    @Column(name="max_participants", nullable=false)
    private int maxParticipants;

    public ChatRoom() {
        this.createdAt = Instant.now();
        this.lastActivity = Instant.now();
        this.participants = new HashSet();
        this.active = true;
        this.maxParticipants = 100;
    }

    @Generated
    protected ChatRoom(ChatRoomBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.description = b.description;
        this.createdBy = b.createdBy;
        this.createdAt = b.createdAt;
        this.lastActivity = b.lastActivity;
        this.participants = b.participants;
        this.active = b.active;
        this.maxParticipants = b.maxParticipants;
    }

    @Generated
    public static ChatRoomBuilder<?, ?> builder() {
        return new ChatRoomBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public UUID getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getLastActivity() {
        return this.lastActivity;
    }

    @Generated
    public Set<UUID> getParticipants() {
        return this.participants;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public int getMaxParticipants() {
        return this.maxParticipants;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCreatedBy(UUID createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    @Generated
    public void setParticipants(Set<UUID> participants) {
        this.participants = participants;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setMaxParticipants(int maxParticipants) {
        this.maxParticipants = maxParticipants;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatRoom)) {
            return false;
        }
        ChatRoom other = (ChatRoom)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (this.getMaxParticipants() != other.getMaxParticipants()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        UUID this$createdBy = this.getCreatedBy();
        UUID other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$lastActivity = this.getLastActivity();
        Instant other$lastActivity = other.getLastActivity();
        if (this$lastActivity == null ? other$lastActivity != null : !((Object)this$lastActivity).equals(other$lastActivity)) {
            return false;
        }
        Set this$participants = this.getParticipants();
        Set other$participants = other.getParticipants();
        return !(this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatRoom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isActive() ? 79 : 97);
        result = result * 59 + this.getMaxParticipants();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        UUID $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $lastActivity = this.getLastActivity();
        result = result * 59 + ($lastActivity == null ? 43 : ((Object)$lastActivity).hashCode());
        Set $participants = this.getParticipants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        return result;
    }
}

