/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.DirectConversationApi;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputCreateDirectConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.DirectConversationService;
import jakarta.validation.Valid;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DirectConversationController
implements DirectConversationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectConversationController.class);
    private final DirectConversationService directConversationService;

    public ResponseEntity<OutputConversationDto> createDirectConversation(@Valid InputCreateDirectConversationDto request) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        OutputConversationDto conversationDto = this.directConversationService.createOrGetDirectConversation(userId, request.getUser2Id());
        log.info("Direct conversation created/retrieved between {} and {}: {}", new Object[]{userId, request.getUser2Id(), conversationDto.getId()});
        return ResponseEntity.ok((Object)conversationDto);
    }

    public ResponseEntity<OutputConversationDto> getDirectConversationForUserAndReceiver(UUID receiverId) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        OutputConversationDto conversationDto = this.directConversationService.getDirectConversation(userId, receiverId);
        return ResponseEntity.ok((Object)conversationDto);
    }

    @Generated
    public DirectConversationController(DirectConversationService directConversationService) {
        this.directConversationService = directConversationService;
    }
}

