package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.User;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.security.WebSocketUser;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service contract for managing websocket sessions.
 * Each method is documented to improve generated JavaDoc and maintainability.
 */
public interface SessionManagementService {

    /**
     * Callback method to call when a user connects to a web socket session.
     *
     * @param sessionId the STOMP session id
     * @param user      the connected user
     * @return the {@link User} entity if it was updated, null otherwise
     */
    User onSessionCreated(@NonNull String sessionId, @NonNull WebSocketUser user);

    /**
     * Callback method to call when a user disconnects from a web socket session.
     *
     * @param sessionId the STOMP session id
     * @return the {@link User} entity if it was updated, null otherwise
     */
    User onSessionDestroyed(@NonNull String sessionId);

    /**
     * Returns if the user has any active session and so is considered as online.
     *
     * @param userId the user id
     * @return {@code true} if online, {@code false} otherwise
     */
    boolean isUserOnline(@NonNull UUID userId);

    /**
     * Returns the count of sessions for the provider user id
     *
     * @param userId the user id
     * @return the session count
     */
    int getUserSessionCount(@NonNull UUID userId);
}
