package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import org.springframework.lang.NonNull;

/**
 * Service to handle all messaging to send chat messages to appropriate messaging queues.
 */
public interface MessagingService {
    /**
     * Sends a chat message to the chat queue
     */
    void sendChatMessage(@NonNull ChatMessage chatMessage);

    /**
     * Sends a user notification message to the user notification queue
     */
    void sendUserNotification(@NonNull ChatMessage notification);

}
