package com.finconsgroup.itserr.marketplace.usercommunication.dm.service;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service contract for managing direct conversations.
 * Each method is documented to improve generated JavaDoc and maintainability.
 */
public interface DirectConversationService {
    /**
     * Create a new direct conversation between two distinct users or return the existing one.
     * @param user1Id first participant user ID
     * @param user2Id second participant user ID
     * @return the created or existing Conversation entity
     * @throws IllegalArgumentException if user IDs are invalid or equal
     */
    OutputConversationDto createOrGetDirectConversation(@NonNull UUID user1Id, @NonNull UUID user2Id);

    /**
     * Get the direct conversations between two users.
     * @param user1Id first participant user ID
     * @param user2Id second participant user ID
     * @return the found direct conversations
     */
    OutputConversationDto getDirectConversation(@NonNull UUID user1Id, @NonNull UUID user2Id);

}