package com.finconsgroup.itserr.marketplace.usercommunication.dm.security;

import lombok.Getter;
import lombok.experimental.SuperBuilder;

import java.io.Serial;
import java.io.Serializable;
import java.security.Principal;
import java.util.UUID;

@SuperBuilder
@Getter
public class WebSocketUser implements Principal, Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    private final UUID userId;
    private final String username;
    private final String displayName;
    private final String firstName;
    private final String lastName;

    @Override
    public String getName() {
        return displayName;
    }
}
