package com.finconsgroup.itserr.marketplace.usercommunication.dm.repository;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatRoom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Repository
public interface ChatRoomRepository extends JpaRepository<ChatRoom, UUID> {
    // TODO: Check Later as this feature is not a priority for now

//    /**
//     * Find a chat room by its unique chat room ID
//     */
//    @NonNull
//    Optional<ChatRoom> findById(@NonNull UUID chatRoomId);
//
//    /**
//     * Find all active chat rooms
//     */
//    List<ChatRoom> findByActiveTrue();
//
//    /**
//     * Find all inactive chat rooms
//     */
//    List<ChatRoom> findByActiveFalse();
//
//    /**
//     * Find chat rooms created by a specific user
//     */
//    List<ChatRoom> findByCreatedByOrderByCreatedAtDesc(UUID createdBy);
//
//    /**
//     * Find chat rooms by name (case-insensitive search)
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE LOWER(cr.name) LIKE LOWER(CONCAT('%', :name, '%')) AND cr.active = true")
//    List<ChatRoom> findByNameContainingIgnoreCaseAndActiveTrue(@Param("name") String name);
//
//    /**
//     * Find chat rooms where a specific user is a participant
//     */
//    @Query("SELECT cr FROM ChatRoom cr JOIN cr.participants p WHERE p = :userId AND cr.active = true")
//    List<ChatRoom> findByParticipantsContainingAndActiveTrue(@Param("userId") String userId);
//
//    /**
//     * Find chat rooms with recent activity (within specified time)
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE cr.lastActivity >= :since AND cr.active = true ORDER BY cr.lastActivity DESC")
//    List<ChatRoom> findByLastActivityAfterAndActiveTrue(@Param("since") Instant since);
//
//    /**
//     * Find chat rooms ordered by creation date
//     */
//    List<ChatRoom> findByActiveTrueOrderByCreatedAtDesc();
//
//    /**
//     * Find chat rooms ordered by last activity
//     */
//    List<ChatRoom> findByActiveTrueOrderByLastActivityDesc();
//
//    /**
//     * Count active chat rooms
//     */
//    long countByActiveTrue();
//
//    /**
//     * Count chat rooms created by a specific user
//     */
//    long countByCreatedBy(UUID createdBy);
//
//    /**
//     * Update last activity timestamp for a chat room
//     */
//    @Modifying
//    @Query("UPDATE ChatRoom cr SET cr.lastActivity = :timestamp WHERE cr.id = :chatRoomId")
//    void updateLastActivity(@Param("chatRoomId") UUID chatRoomId, @Param("timestamp") Instant timestamp);
//
//    /**
//     * Deactivate a chat room
//     */
//    @Modifying
//    @Query("UPDATE ChatRoom cr SET cr.active = false WHERE cr.id = :chatRoomId")
//    void deactivateChatRoom(@Param("chatRoomId") UUID chatRoomId);
//
//    /**
//     * Activate a chat room
//     */
//    @Modifying
//    @Query("UPDATE ChatRoom cr SET cr.active = true WHERE cr.id = :chatRoomId")
//    void activateChatRoom(@Param("chatRoomId") UUID chatRoomId);
//
//    /**
//     * Find chat rooms with participant count less than max participants (available for joining)
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE SIZE(cr.participants) < cr.maxParticipants AND cr.active = true")
//    List<ChatRoom> findAvailableChatRooms();
//
//    /**
//     * Find chat rooms that are full (participant count equals max participants)
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE SIZE(cr.participants) >= cr.maxParticipants AND cr.active = true")
//    List<ChatRoom> findFullChatRooms();
//
//    /**
//     * Find empty chat rooms (no participants)
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE SIZE(cr.participants) = 0 AND cr.active = true")
//    List<ChatRoom> findEmptyChatRooms();
//
//    /**
//     * Delete inactive chat rooms older than specified date
//     */
//    void deleteByActiveFalseAndCreatedAtBefore(Instant timestamp);
//
//    /**
//     * Find chat rooms by description containing text
//     */
//    @Query("SELECT cr FROM ChatRoom cr WHERE LOWER(cr.description) LIKE LOWER(CONCAT('%', :searchTerm, '%')) AND cr.active = true")
//    List<ChatRoom> findByDescriptionContainingIgnoreCaseAndActiveTrue(@Param("searchTerm") String searchTerm);
//
//    /**
//     * Get participant count for a specific chat room
//     */
//    @Query("SELECT SIZE(cr.participants) FROM ChatRoom cr WHERE cr.id = :chatRoomId")
//    Integer getParticipantCount(@Param("chatRoomId") UUID chatRoomId);
//
//    /**
//     * Check if a user is a participant in a chat room
//     */
//    @Query("SELECT CASE WHEN COUNT(cr) > 0 THEN true ELSE false END FROM ChatRoom cr JOIN cr.participants p WHERE cr.id = :chatRoomId AND p = :userId")
//    boolean isUserParticipant(@Param("chatRoomId") UUID chatRoomId, @Param("userId") String userId);
}