package com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface ConversationMapper {

    /**
     * Converts a {@link Conversation} into a {@link OutputConversationDto}.
     *
     * @param entity the conversation entity
     * @return Created Output Chat Message Dto.
     */
    @Mapping(target = "messageSummary", ignore = true)
    @Mapping(target = "receiver", ignore = true)
    @Mapping(target = "createdByUser", ignore = true)
    OutputConversationDto entityToOutputConversationDto(Conversation entity);

}
