package com.finconsgroup.itserr.marketplace.usercommunication.dm.mapper;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.InputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputChatMessageDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.UUID;

@Mapper(config = MapperConfiguration.class)
public interface ChatMessageMapper {

    /**
     * Converts a {@link InputChatMessageDto} into a {@link ChatMessage}.
     *
     * @param dto create chat message dto
     * @return Created Chat Message Entity.
     */
    @BeanMapping(ignoreByDefault = true)
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "senderId", source = "userId")
    @Mapping(target = "content", source = "dto.content")
    @Mapping(target = "messageType", source = "dto.messageType")
    ChatMessage inputChatMessageDtoToEntity(InputChatMessageDto dto, UUID userId);

    /**
     * Converts a {@link ChatMessage} into a {@link OutputChatMessageDto}.
     *
     * @param entity the chat message entity
     * @return Created Output Chat Message Dto.
     */
    @Mapping(target = "sender", ignore = true)
    @Mapping(target = "conversationName", ignore = true)
    @Mapping(target = "requestMessageId", ignore = true)
    @Mapping(target = "readReceipts", ignore = true)
    OutputChatMessageDto entityToOutputChatMessageDto(ChatMessage entity);


}
