package com.finconsgroup.itserr.marketplace.usercommunication.dm.controller;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.api.ChatApi;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequiredArgsConstructor
@Slf4j
public class ChatController implements ChatApi {

    // TODO: Check Later as this feature is not a priority for now

//    private final ChatMessageProducer messageProducer;
//    private final ChatMessageService chatMessageService;
//    private final ChatRoomService chatRoomService;
//    private final SimpMessagingTemplate messagingTemplate;
//
//    /**
//     * Send a chat message via REST.
//     * Validates that the sender belongs to the target chat room (when chatRoomId is provided),
//     * enriches the payload with missing metadata (messageId, timestamp), persists/dispatches
//     * through Messaging Service, and broadcasts to the WebSocket topic for real-time delivery.
//     *
//     * @param message Chat message payload containing sender info and content; may contain chatRoomId
//     * @return 200 with a success message when dispatched; 403 if sender not in room; 500 on error
//     */
//    @Override
//    public ResponseEntity<String> sendMessage(@Valid @RequestBody ChatMessage message) {
//        try {
//            // Validate that the user is in the chat room (if specified)
//            if (message.getChatRoomId() != null &&
//                !chatRoomService.isUserInChatRoom(message.getChatRoomId(), message.getSenderId())) {
//                return ResponseEntity.status(HttpStatus.FORBIDDEN)
//                    .body("User is not a participant in the specified chat room");
//            }
//
//            // Set message metadata if not present
//            if (message.getMessageId() == null || message.getMessageId().isEmpty()) {
//                message.setMessageId(UUID.randomUUID().toString());
//            }
//            if (message.getCreatedAt() == null) {
//                message.setCreatedAt(LocalDateTime.now());
//            }
//
//            // Send message to Messaging Service for processing and persistence
//            messageProducer.sendChatMessage(message);
//
//            // Also broadcast via WebSocket for real-time delivery
//            if (message.getChatRoomId() != null) {
//                messagingTemplate.convertAndSend("/topic/room/" + message.getChatRoomId(), message);
//            }
//
//            log.info("Message sent successfully via REST API: {}", message.getMessageId());
//
//            return ResponseEntity.ok("Message sent successfully");
//        } catch (Exception e) {
//            log.error("Failed to send message", e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
//                .body("Failed to send message: " + e.getMessage());
//        }
//    }
//
//    /**
//     * Retrieve messages for a chat room.
//     * Validates room existence and returns the messages ordered appropriately.
//     *
//     * @param chatRoomId business identifier of the chat room
//     * @return 200 with message list; 404 if room not found; 500 on server error
//     */
//    @Override
//    public ResponseEntity<List<ChatMessage>> getChatRoomMessages(@PathVariable String chatRoomId) {
//        try {
//            Optional<ChatRoom> chatRoom = chatRoomService.getChatRoom(chatRoomId);
//            if (chatRoom.isEmpty()) {
//                return ResponseEntity.notFound().build();
//            }
//
//            List<ChatMessage> messages = chatMessageService.getConversationMessages(chatRoomId);
//            return ResponseEntity.ok(messages);
//        } catch (Exception e) {
//            log.error("Failed to get messages for chat room: {}", chatRoomId, e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
//        }
//    }
//
//    /**
//     * Create a new chat room and add the creator as a participant.
//     *
//     * @param request request body containing name, description and createdBy
//     * @return 201 with created ChatRoom; 500 on failure
//     */
//    @Override
//    public ResponseEntity<ChatRoom> createChatRoom(@RequestBody CreateChatRoomRequest request) {
//        try {
//            ChatRoom chatRoom = chatRoomService.createChatRoom(
//                request.getName(),
//                request.getDescription(),
//                request.getCreatedBy()
//            );
//
//            // Add the creator to the chat room
//            chatRoomService.addUserToChatRoom(chatRoom.getId(), request.getCreatedBy());
//
//            log.info("Chat room created: {}", chatRoom.getChatRoomId());
//            return ResponseEntity.status(HttpStatus.CREATED).body(chatRoom);
//        } catch (Exception e) {
//            log.error("Failed to create chat room", e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
//        }
//    }
//
//    /**
//     * Get all active chat rooms.
//     *
//     * @return 200 with the list of active rooms; 500 on error
//     */
//    @Override
//    public ResponseEntity<List<ChatRoom>> getAllChatRooms() {
//        try {
//            List<ChatRoom> chatRooms = chatRoomService.getAllActiveChatRooms();
//            return ResponseEntity.ok(chatRooms);
//        } catch (Exception e) {
//            log.error("Failed to get chat rooms", e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
//        }
//    }
//
//    /**
//     * Get details of a specific chat room by its business identifier.
//     *
//     * @param chatRoomId business identifier of the chat room
//     * @return 200 with room details; 404 if not found; 500 on error
//     */
//    @Override
//    public ResponseEntity<ChatRoom> getChatRoom(@PathVariable String chatRoomId) {
//        try {
//            Optional<ChatRoom> chatRoom = chatRoomService.getChatRoom(chatRoomId);
//            return chatRoom.map(ResponseEntity::ok)
//                          .orElse(ResponseEntity.notFound().build());
//        } catch (Exception e) {
//            log.error("Failed to get chat room: {}", chatRoomId, e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
//        }
//    }
//
//    /**
//     * Join a chat room as a user.
//     * Sends JOIN notification via Messaging Service and broadcasts a JOIN event via WebSocket.
//     *
//     * @param chatRoomId room to join
//     * @param request payload with userId and username
//     * @return 200 when joined; 400 if join failed; 500 on server error
//     */
//    @Override
//    public ResponseEntity<String> joinChatRoom(@PathVariable String chatRoomId,
//                                              @RequestBody JoinChatRoomRequest request) {
//        try {
//            boolean success = chatRoomService.addUserToChatRoom(chatRoomId, request.getUserId());
//            if (success) {
//                // Send join notification through Messaging Service
//                messageProducer.sendJoinNotification(request.getUserId(), request.getUsername(), chatRoomId);
//
//                // Also broadcast via WebSocket for real-time notification
//                ChatMessage joinMessage = new ChatMessage();
//                joinMessage.setMessageId(UUID.randomUUID().toString());
//                joinMessage.setSenderId(request.getUserId());
//                joinMessage.setSenderName(request.getUsername());
//                joinMessage.setContent(request.getUsername() + " joined the chat");
//                joinMessage.setMessageType(MessageType.JOIN);
//                joinMessage.setChatRoomId(chatRoomId);
//                joinMessage.setCreatedAt(LocalDateTime.now());
//
//                messagingTemplate.convertAndSend("/topic/room/" + chatRoomId, joinMessage);
//
//                return ResponseEntity.ok("Successfully joined chat room");
//            } else {
//                return ResponseEntity.status(HttpStatus.BAD_REQUEST)
//                    .body("Failed to join chat room");
//            }
//        } catch (Exception e) {
//            log.error("Failed to join chat room: {}", chatRoomId, e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
//                .body("Failed to join chat room: " + e.getMessage());
//        }
//    }
//
//    /**
//     * Leave a chat room as a user.
//     * Sends LEAVE notification via Messaging Service and broadcasts a LEAVE event via WebSocket.
//     *
//     * @param chatRoomId room to leave
//     * @param request payload with userId and username
//     * @return 200 when left; 400 if leave failed; 500 on server error
//     */
//    @Override
//    public ResponseEntity<String> leaveChatRoom(@PathVariable String chatRoomId,
//                                               @RequestBody LeaveChatRoomRequest request) {
//        try {
//            boolean success = chatRoomService.removeUserFromChatRoom(chatRoomId, request.getUserId());
//            if (success) {
//                // Send leave notification through Messaging Service
//                messageProducer.sendLeaveNotification(request.getUserId(), request.getUsername(), chatRoomId);
//
//                // Also broadcast via WebSocket for real-time notification
//                ChatMessage leaveMessage = new ChatMessage();
//                leaveMessage.setMessageId(UUID.randomUUID().toString());
//                leaveMessage.setSenderId(request.getUserId());
//                leaveMessage.setSenderName(request.getUsername());
//                leaveMessage.setContent(request.getUsername() + " left the chat");
//                leaveMessage.setMessageType(MessageType.LEAVE);
//                leaveMessage.setChatRoomId(chatRoomId);
//                leaveMessage.setCreatedAt(LocalDateTime.now());
//
//                messagingTemplate.convertAndSend("/topic/room/" + chatRoomId, leaveMessage);
//
//                return ResponseEntity.ok("Successfully left chat room");
//            } else {
//                return ResponseEntity.status(HttpStatus.BAD_REQUEST)
//                    .body("Failed to leave chat room");
//            }
//        } catch (Exception e) {
//            log.error("Failed to leave chat room: {}", chatRoomId, e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
//                .body("Failed to leave chat room: " + e.getMessage());
//        }
//    }
//
//    /**
//     * Send typing indicator status for a user in a room.
//     *
//     * @param chatRoomId target room
//     * @param request payload carrying userId, username and typing flag
//     * @return 200 when dispatched; 500 on error
//     */
//    @Override
//    public ResponseEntity<String> sendTypingIndicator(@PathVariable String chatRoomId,
//                                                     @RequestBody TypingIndicatorRequest request) {
//        try {
//            messageProducer.sendTypingIndicator(
//                request.getUserId(),
//                request.getUsername(),
//                chatRoomId,
//                request.isTyping()
//            );
//            return ResponseEntity.ok("Typing indicator sent");
//        } catch (Exception e) {
//            log.error("Failed to send typing indicator", e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
//                .body("Failed to send typing indicator: " + e.getMessage());
//        }
//    }
//
//    /**
//     * Get participants of a chat room.
//     *
//     * @param chatRoomId business identifier of the room
//     * @return 200 with user list; 500 on error
//     */
//    @Override
//    public ResponseEntity<List<User>> getChatRoomParticipants(@PathVariable String chatRoomId) {
//        try {
//            List<User> participants = chatRoomService.getChatRoomParticipants(chatRoomId);
//            return ResponseEntity.ok(participants);
//        } catch (Exception e) {
//            log.error("Failed to get chat room participants: {}", chatRoomId, e);
//            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
//        }
//    }
//
//    // Request DTOs
//    public static class CreateChatRoomRequest {
//        private String name;
//        private String description;
//        private String createdBy;
//
//        // Getters and setters
//        public String getName() { return name; }
//        public void setName(String name) { this.name = name; }
//        public String getDescription() { return description; }
//        public void setDescription(String description) { this.description = description; }
//        public String getCreatedBy() { return createdBy; }
//        public void setCreatedBy(String createdBy) { this.createdBy = createdBy; }
//    }
//
//    public static class JoinChatRoomRequest {
//        private String userId;
//        private String username;
//
//        // Getters and setters
//        public String getUserId() { return userId; }
//        public void setUserId(String userId) { this.userId = userId; }
//        public String getUsername() { return username; }
//        public void setUsername(String username) { this.username = username; }
//    }
//
//    public static class LeaveChatRoomRequest {
//        private String userId;
//        private String username;
//
//        // Getters and setters
//        public String getUserId() { return userId; }
//        public void setUserId(String userId) { this.userId = userId; }
//        public String getUsername() { return username; }
//        public void setUsername(String username) { this.username = username; }
//    }
//
//    public static class TypingIndicatorRequest {
//        private String userId;
//        private String username;
//        private boolean typing;
//
//        // Getters and setters
//        public String getUserId() { return userId; }
//        public void setUserId(String userId) { this.userId = userId; }
//        public String getUsername() { return username; }
//        public void setUsername(String username) { this.username = username; }
//        public boolean isTyping() { return typing; }
//        public void setTyping(boolean typing) { this.typing = typing; }
//    }
}