package com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Represents the configuration properties related to security.
 */
@ConfigurationProperties(prefix = "user-communication.dm.security")
@Getter
@AllArgsConstructor
public class UserCommunicationSecurityProperties {

    /**
     * Specifies the audience to be used for JWT verification and roles.
     */
    @NotBlank
    private String audience;

}
