/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.configuration.properties.RabbitMQMessagingClientProperties;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.MessagingService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"type"}, prefix="user-communication.dm.messaging", havingValue="RABBIT")
public class RabbitMQMessagingService
implements MessagingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitMQMessagingService.class);
    private final RabbitTemplate rabbitTemplate;
    private final RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties;

    public void sendChatMessage(@NonNull ChatMessage chatMessage) {
        log.info("Sending chat message: {} from user: {} to exchange: {}", new Object[]{chatMessage.getId(), chatMessage.getSenderId(), this.rabbitMQMessagingClientProperties.getChat().getExchange()});
        this.rabbitTemplate.convertAndSend(this.rabbitMQMessagingClientProperties.getChat().getExchange(), this.rabbitMQMessagingClientProperties.getChat().getChatRoutingKey(), (Object)chatMessage);
    }

    public void sendUserNotification(@NonNull ChatMessage notification) {
        this.rabbitTemplate.convertAndSend(this.rabbitMQMessagingClientProperties.getChat().getExchange(), this.rabbitMQMessagingClientProperties.getChat().getUserNotificationRoutingKey(), (Object)notification);
    }

    @Generated
    public RabbitMQMessagingService(RabbitTemplate rabbitTemplate, RabbitMQMessagingClientProperties rabbitMQMessagingClientProperties) {
        this.rabbitTemplate = rabbitTemplate;
        this.rabbitMQMessagingClientProperties = rabbitMQMessagingClientProperties;
    }
}

