/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageDestinations;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.MessageHeaders;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.constant.SecurityConstants;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputUnreadMessageSummaryDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ChatMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.OfflineMessage;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.MessageType;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.OfflineMessageRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.ChatMessageProducer;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.OfflineMessageService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.SessionManagementService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OfflineMessageServiceImpl
implements OfflineMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OfflineMessageServiceImpl.class);
    private final OfflineMessageRepository offlineMessageRepository;
    private final SimpMessagingTemplate messagingTemplate;
    private final ChatMessageProducer messageProducer;
    private final SessionManagementService sessionManagementService;
    private final MessageDestinations messageDestinations;

    public void queueMessageForOfflineUser(ChatMessage chatMessage, UUID recipientUserId) {
        try {
            if (this.offlineMessageRepository.existsByMessageIdAndRecipientUserId(chatMessage.getId(), recipientUserId)) {
                log.debug("Message {} already queued for user {}", (Object)chatMessage.getId(), (Object)recipientUserId);
                return;
            }
            OfflineMessage offlineMessage = new OfflineMessage(chatMessage.getId(), recipientUserId, chatMessage.getConversationId(), chatMessage.getSenderId(), chatMessage.getContent(), chatMessage.getMessageType(), chatMessage.getCreatedAt());
            this.offlineMessageRepository.save((Object)offlineMessage);
            log.info("Queued message {} for offline user {}", (Object)chatMessage.getId(), (Object)recipientUserId);
        }
        catch (Exception e) {
            log.error("Failed to queue message {} for user {}: {}", new Object[]{chatMessage.getId(), recipientUserId, e.getMessage(), e});
        }
    }

    public void notifyUserAboutPendingMessages(UUID userId) {
        try {
            long messageCount = this.getUndeliveredMessageCount(userId);
            if (messageCount > 0L) {
                String notificationContent;
                List recentMessages = this.getUndeliveredMessages(userId);
                String lastSenderName = null;
                String lastMessageContent = null;
                if (!recentMessages.isEmpty()) {
                    OfflineMessage lastMessage = (OfflineMessage)recentMessages.get(recentMessages.size() - 1);
                    lastMessageContent = lastMessage.getContent();
                }
                if (lastSenderName != null) {
                    if (messageCount == 1L) {
                        notificationContent = String.format("%s sent you a message. Connect to read it.", lastSenderName);
                        if (lastMessageContent != null && !lastMessageContent.isEmpty()) {
                            truncatedContent = lastMessageContent.length() > 50 ? lastMessageContent.substring(0, 50) + "..." : lastMessageContent;
                            notificationContent = String.format("%s sent you a message: \"%s\". Connect to read the full message.", lastSenderName, truncatedContent);
                        }
                    } else {
                        notificationContent = String.format("You have %d unread messages waiting for you. Latest from %s. Connect to read them.", messageCount, lastSenderName);
                        if (lastMessageContent != null && !lastMessageContent.isEmpty()) {
                            truncatedContent = lastMessageContent.length() > 50 ? lastMessageContent.substring(0, 50) + "..." : lastMessageContent;
                            notificationContent = String.format("You have %d unread messages waiting for you. Latest from %s: \"%s\". Connect to read them.", messageCount, lastSenderName, truncatedContent);
                        }
                    }
                } else {
                    notificationContent = String.format("You have %d unread message%s waiting for you. Connect to read %s.", messageCount, messageCount == 1L ? "" : "s", messageCount == 1L ? "it" : "them");
                }
                this.messageProducer.sendUserNotification(userId, notificationContent, MessageType.NOTIFICATION);
                ChatMessage notification = new ChatMessage();
                notification.setId(UUID.randomUUID());
                notification.setSenderId(SecurityConstants.SYSTEM_USER_ID);
                notification.setReceiverId(userId);
                notification.setContent(notificationContent);
                notification.setMessageType(MessageType.NOTIFICATION);
                notification.setCreatedAt(Instant.now());
                if (lastSenderName != null) {
                    String enhancedContent = notification.getContent() + "||SENDER:" + lastSenderName + (String)(lastMessageContent != null ? "||MESSAGE:" + lastMessageContent : "");
                    notification.setContent(enhancedContent);
                }
                this.messagingTemplate.convertAndSendToUser(userId.toString(), this.messageDestinations.getUserNotificationsSuffix(), (Object)notification, MessageHeaders.USER_DESTINATION_DEFAULTS);
                log.info("Sent pending messages notification to user {}: {} messages from {}", new Object[]{userId, messageCount, lastSenderName != null ? lastSenderName : "unknown"});
            }
        }
        catch (Exception e) {
            log.error("Failed to send pending messages notification to user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    public void deliverOfflineMessages(UUID userId) {
        try {
            List queuedMessages = this.offlineMessageRepository.findByRecipientUserIdAndDeliveredFalseOrderByCreatedAtAsc(userId);
            if (queuedMessages.isEmpty()) {
                log.debug("No offline messages to deliver for user {}", (Object)userId);
                return;
            }
            this.notifyUserAboutPendingMessages(userId);
            log.info("Delivering {} offline messages to user {}", (Object)queuedMessages.size(), (Object)userId);
            for (OfflineMessage offlineMessage : queuedMessages) {
                try {
                    ChatMessage chatMessage = this.convertToCharMessage(offlineMessage);
                    chatMessage.setContent(chatMessage.getContent() + "||BULK_OFFLINE_DELIVERY||");
                    this.messagingTemplate.convertAndSendToUser(userId.toString(), this.messageDestinations.getUserMessagesSuffix(), (Object)chatMessage, MessageHeaders.USER_DESTINATION_DEFAULTS);
                    this.messagingTemplate.convertAndSend((Object)this.messageDestinations.getConversationTopic(offlineMessage.getConversationId()), (Object)chatMessage);
                    offlineMessage.setDelivered(true);
                    this.offlineMessageRepository.save((Object)offlineMessage);
                    log.debug("Delivered offline message {} to user {}", (Object)offlineMessage.getMessageId(), (Object)userId);
                }
                catch (Exception e) {
                    log.error("Failed to deliver offline message {} to user {}: {}", new Object[]{offlineMessage.getMessageId(), userId, e.getMessage(), e});
                }
            }
            log.info("Successfully delivered {} offline messages to user {}", (Object)queuedMessages.size(), (Object)userId);
        }
        catch (Exception e) {
            log.error("Failed to deliver offline messages to user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    public boolean isUserOnline(UUID userId) {
        return this.sessionManagementService.isUserOnline(userId);
    }

    public long getUndeliveredMessageCount(UUID userId) {
        return this.offlineMessageRepository.countByRecipientUserIdAndDeliveredFalse(userId);
    }

    public long getUndeliveredMessageCount(UUID userId, UUID conversationId) {
        return this.offlineMessageRepository.countByRecipientUserIdAndConversationIdAndDeliveredFalse(userId, conversationId);
    }

    public List<OfflineMessage> getUndeliveredMessages(UUID userId) {
        return this.offlineMessageRepository.findByRecipientUserIdAndDeliveredFalseOrderByCreatedAtAsc(userId);
    }

    public OutputUnreadMessageSummaryDto getUnreadMessageSummary(UUID userId) {
        long totalUnreadCount = this.getUndeliveredMessageCount(userId);
        if (totalUnreadCount == 0L) {
            return new OutputUnreadMessageSummaryDto(0L, null);
        }
        Optional earliestUnreadMessage = this.offlineMessageRepository.findTop1ByRecipientUserIdAndDeliveredFalseOrderByCreatedAtAsc(userId);
        String lastSenderMessage = earliestUnreadMessage.map(OfflineMessage::getContent).orElse(null);
        return new OutputUnreadMessageSummaryDto(totalUnreadCount, lastSenderMessage);
    }

    public void cleanupOldDeliveredMessages(int daysOld) {
        try {
            Instant cutoffDate = Instant.now().minus(daysOld, ChronoUnit.DAYS);
            int deletedCount = this.offlineMessageRepository.deleteDeliveredMessagesOlderThan(cutoffDate);
            if (deletedCount > 0) {
                log.info("Cleaned up {} old delivered messages older than {} days", (Object)deletedCount, (Object)daysOld);
            }
        }
        catch (Exception e) {
            log.error("Failed to cleanup old delivered messages: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void handleMessageDelivery(ChatMessage chatMessage, UUID recipientUserId) {
        if (this.isUserOnline(recipientUserId)) {
            try {
                this.messagingTemplate.convertAndSendToUser(recipientUserId.toString(), this.messageDestinations.getUserMessagesSuffix(), (Object)chatMessage, MessageHeaders.USER_DESTINATION_DEFAULTS);
                chatMessage.setDelivered(true);
                log.debug("Delivered message {} directly to online user {}", (Object)chatMessage.getId(), (Object)recipientUserId);
            }
            catch (Exception e) {
                log.error("Failed to deliver message {} to online user {}: {}", new Object[]{chatMessage.getId(), recipientUserId, e.getMessage(), e});
                this.queueMessageForOfflineUser(chatMessage, recipientUserId);
            }
        } else {
            this.queueMessageForOfflineUser(chatMessage, recipientUserId);
            log.info("Queued message for offline user {}. They will be notified when they come online.", (Object)recipientUserId);
        }
    }

    public void sendOfflineMessageNotification(UUID userId) {
        try {
            long messageCount = this.getUndeliveredMessageCount(userId);
            if (messageCount > 0L) {
                ChatMessage notification = new ChatMessage();
                notification.setId(UUID.randomUUID());
                notification.setSenderId(SecurityConstants.SYSTEM_USER_ID);
                notification.setReceiverId(userId);
                notification.setMessageType(MessageType.SYSTEM);
                notification.setCreatedAt(Instant.now());
                String notificationText = messageCount == 1L ? "You have 1 new message waiting for you." : String.format("You have %d new messages waiting for you.", messageCount);
                notification.setContent(notificationText);
                this.messagingTemplate.convertAndSendToUser(userId.toString(), this.messageDestinations.getUserNotificationsSuffix(), (Object)notification, MessageHeaders.USER_DESTINATION_DEFAULTS);
                log.info("Sent offline message notification to user {}: {} messages pending", (Object)userId, (Object)messageCount);
            }
        }
        catch (Exception e) {
            log.error("Failed to send offline message notification to user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    private ChatMessage convertToCharMessage(OfflineMessage offlineMessage) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setId(offlineMessage.getMessageId());
        chatMessage.setSenderId(offlineMessage.getSenderId());
        chatMessage.setReceiverId(offlineMessage.getRecipientUserId());
        chatMessage.setContent(offlineMessage.getContent());
        chatMessage.setMessageType(offlineMessage.getMessageType());
        chatMessage.setCreatedAt(offlineMessage.getCreatedAt());
        chatMessage.setConversationId(offlineMessage.getConversationId());
        chatMessage.setDelivered(true);
        chatMessage.setDeliveredAt(Instant.now());
        return chatMessage;
    }

    @Generated
    public OfflineMessageServiceImpl(OfflineMessageRepository offlineMessageRepository, SimpMessagingTemplate messagingTemplate, ChatMessageProducer messageProducer, SessionManagementService sessionManagementService, MessageDestinations messageDestinations) {
        this.offlineMessageRepository = offlineMessageRepository;
        this.messagingTemplate = messagingTemplate;
        this.messageProducer = messageProducer;
        this.sessionManagementService = sessionManagementService;
        this.messageDestinations = messageDestinations;
    }
}

