/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ConversationParticipant;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.enums.ParticipantRole;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationParticipantRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.GroupConversationService;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.PreConditionService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupConversationServiceImpl
implements GroupConversationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupConversationServiceImpl.class);
    private final PreConditionService preConditionService;
    private final ConversationRepository conversationRepository;
    private final ConversationParticipantRepository participantRepository;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Conversation createGroupConversation(String name, String description, UUID createdBy) {
        UUID conversationId = UUID.randomUUID();
        Conversation conversation = Conversation.createGroupConversation((UUID)conversationId, (String)name, (UUID)createdBy);
        conversation.setDescription(description);
        conversation = (Conversation)this.conversationRepository.save((Object)conversation);
        ConversationParticipant owner = ConversationParticipant.createOwner((UUID)conversationId, (UUID)createdBy);
        this.participantRepository.save((Object)owner);
        log.info("Created new group conversation '{}' by {}: {}", new Object[]{name, createdBy, conversationId});
        return conversation;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void inviteUserToGroup(UUID conversationId, UUID userId, UUID invitedBy) {
        Conversation conversation = this.preConditionService.checkUserAndConversation(invitedBy, conversationId);
        if (!this.participantRepository.hasAdminPrivileges(conversationId, invitedBy)) {
            log.warn("User {} does not have admin privileges to invite users to conversation {}", (Object)invitedBy, (Object)conversationId);
            throw new WP2AuthorizationException("Unauthorized");
        }
        long currentParticipants = this.participantRepository.countByConversationIdAndActiveIsTrue(conversationId);
        if (currentParticipants >= (long)conversation.getMaxParticipants().intValue()) {
            log.warn("Conversation {} has reached maximum participants limit", (Object)conversationId);
            throw new WP2ValidationException("Conversation has reached maximum participants limit");
        }
        ConversationParticipant participant = ConversationParticipant.createInvitedMember((UUID)conversationId, (UUID)userId, (UUID)invitedBy);
        this.participantRepository.save((Object)participant);
        log.info("User {} invited to group conversation {} by {}", new Object[]{userId, conversationId, invitedBy});
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean removeUserFromGroup(UUID conversationId, UUID userId, UUID removedBy) {
        Optional conversationOpt = this.conversationRepository.findById(conversationId);
        if (conversationOpt.isEmpty() || !((Conversation)conversationOpt.get()).isGroup()) {
            return false;
        }
        if (!removedBy.equals(userId) && !this.participantRepository.hasAdminPrivileges(conversationId, removedBy)) {
            log.warn("User {} does not have permission to remove user {} from conversation {}", new Object[]{removedBy, userId, conversationId});
            return false;
        }
        Optional participantOpt = this.participantRepository.findByConversationIdAndUserId(conversationId, userId);
        if (participantOpt.isPresent() && ((ConversationParticipant)participantOpt.get()).isOwner() && !removedBy.equals(userId)) {
            log.warn("Cannot remove owner {} from conversation {} unless they remove themselves", (Object)userId, (Object)conversationId);
            return false;
        }
        this.participantRepository.removeParticipant(conversationId, userId);
        log.info("User {} removed from group conversation {} by {}", new Object[]{userId, conversationId, removedBy});
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void promoteUserToAdmin(UUID conversationId, UUID userId, UUID promotedBy) {
        if (!this.participantRepository.hasAdminPrivileges(conversationId, promotedBy)) {
            log.warn("User {} does not have admin privileges to promote users in conversation {}", (Object)promotedBy, (Object)conversationId);
            throw new WP2AuthorizationException("Unauthorized");
        }
        Optional participantOpt = this.participantRepository.findByConversationIdAndUserId(conversationId, userId);
        if (participantOpt.isEmpty() || !((ConversationParticipant)participantOpt.get()).isActive()) {
            log.warn("User {} is not an active participant in conversation {}", (Object)userId, (Object)conversationId);
            throw new WP2ValidationException("User is not an active participant");
        }
        ConversationParticipant participant = (ConversationParticipant)participantOpt.get();
        if (participant.isAdmin() || participant.isOwner()) {
            log.warn("User {} is already an admin or owner in conversation {}", (Object)userId, (Object)conversationId);
            return;
        }
        this.participantRepository.updateParticipantRole(conversationId, userId, ParticipantRole.ADMIN);
        log.info("User {} promoted to admin in conversation {} by {}", new Object[]{userId, conversationId, promotedBy});
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public boolean isUserParticipant(UUID conversationId, UUID userId) {
        return this.participantRepository.existsByConversationIdAndUserIdAndActiveIsTrue(conversationId, userId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public boolean hasAdminPrivileges(UUID conversationId, UUID userId) {
        return this.participantRepository.hasAdminPrivileges(conversationId, userId);
    }

    @Generated
    public GroupConversationServiceImpl(PreConditionService preConditionService, ConversationRepository conversationRepository, ConversationParticipantRepository participantRepository) {
        this.preConditionService = preConditionService;
        this.conversationRepository = conversationRepository;
        this.participantRepository = participantRepository;
    }
}

