/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.usercommunication.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.component.ConversationHelper;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.dto.OutputConversationDto;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.Conversation;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.entity.ConversationParticipant;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationParticipantRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.repository.ConversationRepository;
import com.finconsgroup.itserr.marketplace.usercommunication.dm.service.DirectConversationService;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectConversationServiceImpl
implements DirectConversationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectConversationServiceImpl.class);
    private final ConversationHelper conversationHelper;
    private final ConversationRepository conversationRepository;
    private final ConversationParticipantRepository participantRepository;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputConversationDto createOrGetDirectConversation(@NonNull UUID user1Id, @NonNull UUID user2Id) {
        Objects.requireNonNull(user1Id, "user1Id is null");
        Objects.requireNonNull(user2Id, "user2Id is null");
        try {
            if (user1Id.equals(user2Id)) {
                throw new WP2ValidationException("Cannot create direct conversation with the same user");
            }
            Optional existing = this.conversationRepository.findDirectConversationBetweenUsers(user1Id, user2Id);
            if (existing.isPresent()) {
                log.info("Found existing direct conversation between {} and {}: {}", new Object[]{user1Id, user2Id, ((Conversation)existing.get()).getId()});
                return this.mapToDirectOutputConversationDto(user1Id, (Conversation)existing.get());
            }
            UUID conversationId = UUID.randomUUID();
            Conversation conversation = Conversation.createDirectConversation((UUID)conversationId, (UUID)user1Id, (UUID)user2Id);
            conversation = (Conversation)this.conversationRepository.save((Object)conversation);
            log.info("Created direct conversation entity: {} for users - {} and {}", new Object[]{conversationId, user1Id, user2Id});
            ConversationParticipant participant1 = ConversationParticipant.createMember((UUID)conversationId, (UUID)user1Id);
            ConversationParticipant participant2 = ConversationParticipant.createMember((UUID)conversationId, (UUID)user2Id);
            this.participantRepository.save((Object)participant1);
            this.participantRepository.save((Object)participant2);
            this.conversationHelper.saveConversationUsers(Set.of(user2Id));
            return this.mapToDirectOutputConversationDto(user1Id, conversation);
        }
        catch (Exception e) {
            log.error("Failed to create or get direct conversation between {} and {}: {}", new Object[]{user1Id, user2Id, e.getMessage(), e});
            throw new RuntimeException("Failed to create direct conversation: " + e.getMessage(), e);
        }
    }

    private OutputConversationDto mapToDirectOutputConversationDto(UUID userId, Conversation conversation) {
        return this.conversationHelper.populateDetailsForDirect(userId, conversation);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputConversationDto getDirectConversation(@NonNull UUID user1Id, @NonNull UUID user2Id) {
        Objects.requireNonNull(user1Id, "user1Id is null");
        Objects.requireNonNull(user2Id, "user2Id is null");
        Optional conversationOpt = this.conversationRepository.findDirectConversationBetweenUsers(user1Id, user2Id);
        if (conversationOpt.isEmpty()) {
            throw new WP2ResourceNotFoundException("conversation between %s and %s".formatted(user1Id, user2Id));
        }
        return this.mapToDirectOutputConversationDto(user1Id, (Conversation)conversationOpt.get());
    }

    @Generated
    public DirectConversationServiceImpl(ConversationHelper conversationHelper, ConversationRepository conversationRepository, ConversationParticipantRepository participantRepository) {
        this.conversationHelper = conversationHelper;
        this.conversationRepository = conversationRepository;
        this.participantRepository = participantRepository;
    }
}

